/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.action.PanPlotZoomInAction;
import gov.nasa.giss.panoply.action.PanPlotZoomOutAction;
import gov.nasa.giss.panoply.action.PanPlotZoomResetAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanCommonXAxisControls;
import gov.nasa.giss.panoply.plotui.PanCommonYAxisControls;
import gov.nasa.giss.panoply.plotui.PanGridControls;
import gov.nasa.giss.panoply.plotui.PanScaleControls1D;
import gov.nasa.giss.panoply.plotui.PanZoomableAxisControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanGridControls1D
extends PanGridControls {
    private PanEnumComboBox gridStyleCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private PanIntSpinner tickWeightSpinner_;
    private PanZoomableAxisControls xaxisControls_;
    private PanZoomableAxisControls yaxisControls_;
    private PanScaleControls1D scaleControls_;
    private boolean refreshing_;

    public PanGridControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout(mbar);
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        AbstractAction a = new PanPlotZoomResetAction(this);
        this.pmeta_.putAction("reset-bounds", a);
        plotMenu.getItemByName("reset-bounds").setAction(a);
        a = new PanPlotZoomInAction(this);
        this.pmeta_.putAction("zoom-plot-in", a);
        plotMenu.getItemByName("zoom-plot-in").setAction(a);
        a = new PanPlotZoomOutAction(this);
        this.pmeta_.putAction("zoom-plot-out", a);
        plotMenu.getItemByName("zoom-plot-out").setAction(a);
    }

    private void createLayout(PanMenuBar mbar) {
        PanLabel gStyleLabel = PanLabel.small("Grid Style:\u2009");
        this.gridStyleCombo_ = PanEnumComboBox.small("grid.style", PanStrokePattern.class);
        this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        PanLabel gWeightLabel = PanLabel.small(", Weight:\u2009");
        this.gridWeightSpinner_ = PanIntSpinner.smallWeight("grid.weight", this.pmeta_.getInt("grid.weight"), 200);
        PanLabel gPctLabel = PanLabel.small("%");
        this.axesOffsetCB_ = PanCheckBox.small("axes.offset", "Offset axes from grid edges", this.pmeta_.getBoolean("axes.offset"));
        PanLabel aWeightLabel = PanLabel.small("Tickmark Weight:\u2009");
        this.tickWeightSpinner_ = PanIntSpinner.smallWeight("axes.tickmark.weight", this.pmeta_.getInt("axes.tickmark.weight"), 200);
        this.tickWeightSpinner_.setEnabled(!this.axesOffsetCB_.isSelected());
        PanLabel aPctLabel = PanLabel.small("%");
        QuickBox gStyleBox = QuickBox.createCenterBox(gStyleLabel, this.gridStyleCombo_, gWeightLabel, this.gridWeightSpinner_, gPctLabel, Box.createHorizontalStrut(30), PanLabel.small(" \u2014 "), Box.createHorizontalStrut(30), this.axesOffsetCB_, Box.createHorizontalStrut(30), PanLabel.small(" \u2014 "), Box.createHorizontalStrut(30), aWeightLabel, this.tickWeightSpinner_, aPctLabel);
        if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_ == PanPlotType.LL_ZONAL) {
            this.xaxisControls_ = new PanCommonXAxisControls(this.pmeta_, mbar);
        } else {
            this.yaxisControls_ = new PanCommonYAxisControls(this.pmeta_, mbar);
        }
        this.scaleControls_ = new PanScaleControls1D(this.pmeta_, mbar);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRowWeight(3, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.add((Component)gStyleBox, new FGConstraint(0, 0, 2, 1, -1.0, 0.0));
        this.add((Component)new JSeparator(), new FGConstraint(0, 1, 2, 1));
        if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_ == PanPlotType.LL_ZONAL) {
            this.add((Component)this.xaxisControls_, new FGConstraint(0, 2, 0.0, 0.0));
            this.add((Component)this.scaleControls_, new FGConstraint(1, 2, 0.0, 0.0));
        } else {
            this.add((Component)this.scaleControls_, new FGConstraint(0, 2, 0.0, 0.0));
            this.add((Component)this.yaxisControls_, new FGConstraint(1, 2, 0.0, 0.0));
        }
    }

    private void attachListeners() {
        this.gridStyleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("grid.style", (Object)this.gridStyleCombo_.getStringValue());
        });
        this.gridWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("grid.weight", this.gridWeightSpinner_.getIntValue());
        });
        this.axesOffsetCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean checked = this.axesOffsetCB_.isSelected();
            this.pmeta_.setBoolean("axes.offset", checked);
            this.tickWeightSpinner_.setEnabled(!checked);
        });
        this.tickWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("axes.tickmark.weight", this.tickWeightSpinner_.getIntValue());
        });
    }

    @Override
    public void refreshZoomEnabling() {
    }

    @Override
    public void recenter(double x, double y) {
        this.zoom(1.0, x, y);
    }

    @Override
    public void zoomIn() {
        this.zoom(1.5);
    }

    @Override
    public void zoomOut() {
        this.zoom(0.6666666666666666);
    }

    @Override
    public void zoomIn(double centerx, double centery) {
        this.zoom(1.5, centerx, centery);
    }

    @Override
    public void zoomOut(double centerx, double centery) {
        this.zoom(0.6666666666666666, centerx, centery);
    }

    @Override
    public void zoom(double factor) {
        if (this.xaxisControls_ != null) {
            this.xaxisControls_.zoom(factor);
        } else if (this.yaxisControls_ != null) {
            this.yaxisControls_.zoom(factor);
        }
        this.scaleControls_.zoom(factor);
    }

    @Override
    public void zoom(double factor, double centerx, double centery) {
        if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_ == PanPlotType.LL_ZONAL) {
            this.xaxisControls_.zoom(factor, centerx);
            this.scaleControls_.zoom(factor, centery);
        } else {
            this.scaleControls_.zoom(factor, centerx);
            this.yaxisControls_.zoom(factor, centery);
        }
    }

    @Override
    public void dragZoom(double centerx, double centery, double leftx, double topy, double rightx, double bottomy) {
        if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_ == PanPlotType.LL_ZONAL) {
            this.xaxisControls_.setAxisBounds(leftx, rightx);
            this.scaleControls_.setScaleRange(bottomy, topy);
        } else {
            this.scaleControls_.setScaleRange(leftx, rightx);
            this.yaxisControls_.setAxisBounds(bottomy, topy);
        }
    }

    @Override
    public void resetGridBounds() {
        if (this.xaxisControls_ != null) {
            this.xaxisControls_.resetAxisBounds();
        } else if (this.yaxisControls_ != null) {
            this.yaxisControls_.resetAxisBounds();
        }
        this.pmeta_.getAction("fit-scale-to-data").actionPerformed(null);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        this.gridWeightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        this.axesOffsetCB_.setSelected(this.pmeta_.getBoolean("axes.offset"));
        this.tickWeightSpinner_.setValue(this.pmeta_.getInt("axes.tickmark.weight"));
        this.tickWeightSpinner_.setEnabled(!this.axesOffsetCB_.isSelected());
        this.refreshing_ = false;
    }
}

