/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.data.PanDataTime1D;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanZoomableAxisControls;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCommonXAxisControls
extends PanZoomableAxisControls {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static Hashtable<String, String> paramKeys_ = new Hashtable();

    public PanCommonXAxisControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("grid-xaxis-controls", pmeta, mbar);
        this.createLayout(paramKeys_);
    }

    @Override
    protected final boolean isHorizontal() {
        return true;
    }

    @Override
    protected NcAxisType getAxisType() {
        switch (this.ptype_) {
            case LON_VERT: 
            case LON_TIME: {
                return NcAxisType.LON;
            }
            case LAT_VERT: 
            case LAT_TIME: 
            case LL_ZONAL: {
                return NcAxisType.LAT;
            }
            case TIME_LAT: 
            case TIME_VERT: {
                this.axisIsTime_ = true;
                return NcAxisType.TIME;
            }
            case COLOR_CONTOUR: 
            case HORZ_LINE: {
                LOGGER.trace("More detailed tests required to determine axis type.");
                break;
            }
            case VERT_LINE: {
                throw new RuntimeException("Cannot create X axis controls for a vertical line plot");
            }
            case LON_LAT: {
                throw new RuntimeException("Cannot create X axis controls for a lon-lat plot.");
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.ptype_);
            }
        }
        try {
            if (this.data_ instanceof PanDataTime1D) {
                this.axisIsTime_ = true;
            } else if (this.data_ instanceof PanData1D) {
                PanData1D data1d = (PanData1D)this.data_;
                this.axisIsPressure_ = data1d.isAxisPressure();
                this.axisIsHeight_ = data1d.isAxisHeight();
            } else if (this.data_ instanceof PanDataGeneral2D) {
                PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
                NcAxis ax = data2d.getXAxis();
                this.axisIsPressure_ = ax.isPressure();
                this.axisIsHeight_ = ax.isHeight();
                boolean bl = this.axisIsTime_ = ax instanceof NcTimeAxis && ((NcTimeAxis)ax).isUnixTime();
            }
            if (this.axisIsTime_) {
                LOGGER.trace("Axis is TIME.");
                return NcAxisType.TIME;
            }
            NcAxisType atype = this.ptype_.getAxes()[0];
            LOGGER.trace("Axis (atype) is {}.", (Object)atype);
            if (atype == NcAxisType.TIME) {
                this.axisIsTime_ = true;
            }
            return atype;
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot determine X axis type.");
        }
    }

    @Override
    public void resetAxisBounds() {
        double val2;
        double val1;
        PanAxisMethod method = PanAxisMethod.matching(this.pmeta_.getString("xaxis.method"));
        PanPreferences prefs = PanPreferences.getSharedInstance();
        switch (this.ptype_) {
            case LAT_TIME: {
                val1 = prefs.getDouble("plot:lattime.xaxis.begin");
                val2 = prefs.getDouble("plot:lattime.xaxis.end");
                break;
            }
            case LON_TIME: {
                val1 = prefs.getDouble("plot:lontime.xaxis.begin");
                val2 = prefs.getDouble("plot:lontime.xaxis.end");
                break;
            }
            case LAT_VERT: {
                val1 = prefs.getDouble("plot:latvert.xaxis.begin");
                val2 = prefs.getDouble("plot:latvert.xaxis.end");
                break;
            }
            case LON_VERT: {
                val1 = prefs.getDouble("plot:lonvert.xaxis.begin");
                val2 = prefs.getDouble("plot:lonvert.xaxis.end");
                break;
            }
            case LON_LAT: {
                val1 = -180.0;
                val2 = 180.0;
                break;
            }
            case LL_ZONAL: {
                val1 = -90.0;
                val2 = 90.0;
                break;
            }
            case HORZ_LINE: {
                double[] range = ((PanData1D)this.data_).getDefaultAxisRange(method);
                val1 = range[0];
                val2 = range[1];
                break;
            }
            case VERT_LINE: {
                return;
            }
            case TIME_LAT: 
            case COLOR_CONTOUR: {
                PanDataGeneral2D data = (PanDataGeneral2D)this.data_;
                double[] range = data.getDefaultLeftAndRight(method);
                val1 = range[0];
                val2 = range[1];
                break;
            }
            default: {
                LOGGER.debug("Not coded to handle plot type {}", (Object)this.ptype_);
                return;
            }
        }
        this.setAxisBounds(val1, val2);
    }

    static {
        paramKeys_.put("axis.begin", "xaxis.begin");
        paramKeys_.put("axis.end", "xaxis.end");
        paramKeys_.put("axis.method", "xaxis.method");
        paramKeys_.put("axis.units", "xaxis.units");
        paramKeys_.put("axis.units.alt", "xaxis.units.alt");
        paramKeys_.put("axis.div.major", "xaxis.div.major");
        paramKeys_.put("axis.div.minor", "xaxis.div.minor");
        paramKeys_.put("axis.tick.format", "xaxis.tick.format");
        paramKeys_.put("axis.tick.size", "xaxis.tick.size");
        paramKeys_.put("axis.label.custom", "xaxis.label.custom");
        paramKeys_.put("axis.label.text", "xaxis.label.text");
        paramKeys_.put("axis.label.size", "xaxis.label.size");
        paramKeys_.put("swap-axis-bounds", "swap-xbounds");
    }
}

