/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.plotui.PanArraySlicer;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;

public class PanArraySlicePanel
extends PanAbstractControlsPanel {
    private final NcArray nca_;
    private PanArraySlicer[] slicers_;

    public PanArraySlicePanel(PanPlotMeta pmeta, PanMenuBar mbar, NcArray ncarray, int vnum) {
        super("array-slicer " + vnum, pmeta, mbar);
        this.nca_ = ncarray;
        this.setName("[slice panel " + vnum + "]");
        this.setLayout(new BoxLayout(this, 1));
        String btitle = ncarray == null ? "Array " + (vnum + 1) : "Array " + (vnum + 1) + ": " + ncarray.getShortName();
        TitledBorder border = new TitledBorder(btitle);
        GuiUtils.setSizeSmall(border);
        this.setBorder(border);
        if (ncarray == null) {
            PanLabel sliceLabel = PanLabel.small("None selected");
            sliceLabel.setAlignmentX(0.0f);
            this.add(sliceLabel);
        } else if (!ncarray.hasFreeDimensions()) {
            PanLabel sliceLabel = PanLabel.small("No additional dimensions");
            sliceLabel.setAlignmentX(0.0f);
            this.add(sliceLabel);
        } else {
            NcDimension[] freeDims = ncarray.getFreeDimensions();
            this.slicers_ = new PanArraySlicer[freeDims.length];
            for (int i = 0; i < freeDims.length; ++i) {
                PanArraySlicer slicer;
                if (freeDims[i] == null) {
                    this.slicers_[i] = null;
                    continue;
                }
                int ii = i;
                this.slicers_[i] = slicer = new PanArraySlicer(freeDims[i], ncarray.isAveragingDimension(i));
                slicer.setAlignmentX(0.0f);
                this.add(slicer);
                slicer.addActionListener(e -> {
                    int index = slicer.getSelectedIndex();
                    PanPlotFrame pf = this.getParentFrame();
                    pf.getMeta().setDataSlice(vnum, ii, index, null);
                });
            }
        }
    }

    public NcArray getVariableArray() {
        return this.nca_;
    }

    public int getItemCount() {
        if (this.slicers_ == null) {
            return 0;
        }
        return this.slicers_.length;
    }

    public PanArraySlicer getSlicer(int idx) {
        if (this.slicers_ == null) {
            return null;
        }
        if (idx < 0 || idx >= this.slicers_.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.slicers_[idx];
    }

    @Override
    public void flush() {
        for (Component child : this.getComponents()) {
            ActionListener[] listeners;
            if (!(child instanceof PanArraySlicer)) continue;
            PanArraySlicer slicer = (PanArraySlicer)child;
            for (ActionListener al : listeners = slicer.getActionListeners()) {
                slicer.removeActionListener(al);
            }
        }
        super.flush();
    }
}

