/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataLonLat;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanStringUtils;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanMinMaxNote
extends PanPlotPiece {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanData data_;
    private PrintfFormat formatter_;
    private String formatString_;
    private boolean super10_;
    private AttributedString attribLabelStr_;

    public PanMinMaxNote(PanPlotMeta pmeta, PanData data) {
        super(pmeta);
        this.data_ = data;
        this.setOpaque(false);
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void prepareToPaint() {
        double mean;
        double min = this.pmeta_.getScaleMeta().getDataMinimum();
        double max = this.pmeta_.getScaleMeta().getDataMaximum();
        String minStr = "Data Min = " + this.formatter_.sprintfx(min);
        String maxStr = ", Max = " + this.formatter_.sprintfx(max);
        String meanStr = null;
        if (this.data_ instanceof PanDataLonLat && !Double.isNaN(mean = ((PanDataLonLat)((Object)this.data_)).getGlobalMean())) {
            meanStr = ", Mean = " + this.formatter_.sprintfx(mean);
        }
        Font font = this.getFont();
        if (this.super10_) {
            this.attribLabelStr_ = StringUtils.concatenate(PanStringUtils.convertENotationToSuperscript(minStr, font), PanStringUtils.convertENotationToSuperscript(maxStr, font));
            if (meanStr != null) {
                this.attribLabelStr_ = StringUtils.concatenate(this.attribLabelStr_, PanStringUtils.convertENotationToSuperscript(meanStr, font));
            }
        } else {
            StringBuilder sb = new StringBuilder(minStr).append(maxStr);
            if (meanStr != null) {
                sb.append(meanStr);
            }
            this.attribLabelStr_ = new AttributedString(sb.toString());
        }
        this.attribLabelStr_.addAttribute(TextAttribute.FAMILY, font.getFontName());
        this.attribLabelStr_.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
    }

    public void setFontSize(float fh) {
        this.setFont(this.getFont().deriveFont(fh));
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(gx);
        PlotPieceMargins margins = this.getMargins();
        int width = this.getWidth();
        Font f = this.getFont();
        g2d.setFont(f);
        g2d.setColor(this.getForeground());
        FontMetrics fm = g2d.getFontMetrics(f);
        float tascent = fm.getAscent();
        float twidth = GraphicUtils.stringWidth(this.attribLabelStr_, g2d);
        float x = 0.5f * ((float)width - twidth);
        float y = (float)margins.getTop() + tascent;
        GraphicUtils.drawString(g2d, (Object)this.attribLabelStr_, x, y);
        g2d.dispose();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor")) {
            String fn = this.pmeta_.getString("labels.font");
            Font f = this.getFont();
            float fhgt = f != null ? f.getSize2D() : 9.0f;
            this.setFont(PanGraphicUtils.getFont(fn, fhgt));
        }
        if (changeAll || pname.contains("footnote.minmax.format") || pname.contains("scale.tick.format")) {
            String s = this.pmeta_.getString("footnote.minmax.format");
            if (s == null || s.isEmpty() || s.toLowerCase().startsWith("same")) {
                s = this.pmeta_.getString("scale.tick.format");
            }
            if (s == null) {
                LOGGER.warn("Property {} has null value. Using '%.2f'", (Object)"scale.tick.format");
                s = "%.2f";
            }
            this.formatString_ = s;
            this.formatter_ = new PrintfFormat(this.formatString_);
        }
        if (changeAll || pname.contains("labels.super10")) {
            this.super10_ = this.pmeta_.getBoolean("labels.super10");
        }
    }
}

