/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.DayNightMap;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataLonLatGridded;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanLLPlotMapInsert
extends PanPlotPiece {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected BufferedImage dataImage_;
    protected PanData data_;
    protected double srcLeft_ = -180.0;
    protected double srcTop_ = 90.0;
    protected double srcRight_ = 190.0;
    protected double srcBottom_ = -90.0;
    protected BasicStroke borderStroke_ = new BasicStroke(1.5f);
    protected Color gridColor_;
    protected BasicStroke gridStroke_;
    protected int gridWeight_;
    private float gridSpacingLon_;
    private float gridSpacingLat_;
    private boolean gridOffsetLat_;
    private boolean gridLabeled_;
    private int gridLabelStep_;
    protected MapOverlay[] overlays_ = new MapOverlay[3];
    protected int[] overlayWeights_ = new int[3];
    protected Color[] overlayColors_ = new Color[3];
    protected BasicStroke[] overlayStrokes_ = new BasicStroke[3];
    protected SymbolID[] overlaySymbols_ = new SymbolID[3];
    protected double[] overlaySymbolSizes_ = new double[3];
    protected boolean[] overlayMaskInverted_ = new boolean[3];
    protected Font gridFont_;
    protected PrintfFormat scaleFormatter_ = new PrintfFormat("%G");
    protected boolean alphaEnabled_;
    protected KMLData underlay_;
    protected boolean alphaKnockout_;
    protected int alphaLevel1_ = 100;
    protected int alphaLevel2_ = 100;
    protected boolean shadingEnabled_;
    protected int shadingOpacity_ = 50;
    protected double subsolarLon_;
    protected double subsolarLat_;

    public PanLLPlotMapInsert(PanPlotMeta pmeta) {
        super(pmeta);
        this.data_ = pmeta.getData();
        this.setOpaque(false);
        this.parameterChangedPrivate("all");
    }

    public void setDataImage(BufferedImage bimg) {
        this.dataImage_ = bimg;
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        projmeta.setSize(width, height);
        projmeta.setMargins(this.getMargins().getLeft(), this.getMargins().getTop());
        this.updateLonLatEdges();
    }

    @Override
    public void setMargins(int left, int top, int right, int bottom) {
        super.setMargins(left, top, right, bottom);
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        projmeta.setSize(this.getWidth(), this.getHeight());
        projmeta.setMargins(left, top);
        this.updateLonLatEdges();
    }

    @Override
    protected synchronized void paintPiece(Graphics2D g2d, boolean printing) {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        smeta.prepareColorTable(this.alphaKnockout_);
        this.paintMap(g2d, printing, proj, false, true);
    }

    protected abstract void paintMap(Graphics2D var1, boolean var2, AbstractProjection var3, boolean var4, boolean var5);

    protected BufferedImage beginMap(boolean knockout) {
        Dimension gsize = this.pmeta_.getLayout().getDimension("size.gridding");
        BufferedImage tempImage = new BufferedImage(gsize.width, gsize.height, 2);
        if (!knockout) {
            Graphics2D tg2d = tempImage.createGraphics();
            tg2d.setColor(this.pmeta_.getColor("colorbar.invalids"));
            GraphicUtils.fillRect(tg2d, 0.0, 0.0, gsize.width, gsize.height);
            tg2d.dispose();
        }
        return tempImage;
    }

    protected BufferedImage paintPanMaskOverlays(BufferedImage tempImage) {
        for (int i = 0; i < 3; ++i) {
            if (this.overlays_[i] == null || !(this.overlays_[i] instanceof PanMaskOverlay) || this.overlayWeights_[i] <= 0) continue;
            this.paintPanMaskOverlay(tempImage, i);
        }
        return tempImage;
    }

    private void paintPanMaskOverlay(BufferedImage tempImage, int oid) {
        double maskLeft;
        Graphics2D g2d = tempImage.createGraphics();
        PanMaskOverlay moverlay = (PanMaskOverlay)this.overlays_[oid];
        BufferedImage img = moverlay.getMask(this.overlayColors_[oid], this.overlayMaskInverted_[oid]);
        int sww = tempImage.getWidth();
        int shh = tempImage.getHeight();
        int iww = moverlay.getWidth();
        int ihh = moverlay.getHeight();
        double xRatio = (double)sww / (this.srcRight_ - this.srcLeft_);
        double yRatio = (double)shh / (this.srcBottom_ - this.srcTop_);
        float opacity = 0.01f * (float)Math.min(this.overlayWeights_[oid], 100);
        g2d.setClip(0, 0, sww, shh);
        g2d.setComposite(AlphaComposite.getInstance(3, opacity));
        double maskTop = 90.0;
        double maskBottom = -90.0;
        double maskRight = 180.0;
        for (maskLeft = -180.0; maskLeft < this.srcLeft_; maskLeft += 360.0) {
        }
        while (maskLeft >= this.srcRight_) {
            maskLeft -= 360.0;
        }
        while (maskRight <= maskLeft) {
            maskRight += 360.0;
        }
        double x1 = (maskLeft - this.srcLeft_) * xRatio;
        double x2 = (maskRight - this.srcLeft_) * xRatio;
        double y1 = (90.0 - this.srcTop_) * yRatio;
        double y2 = (-90.0 - this.srcTop_) * yRatio;
        g2d.drawImage(img, (int)x1, (int)y1, (int)x2, (int)y2, 0, 0, iww, ihh, this);
        if (maskRight > this.srcRight_) {
            x1 = ((maskLeft -= 360.0) - this.srcLeft_) * xRatio;
            x2 = ((maskRight -= 360.0) - this.srcLeft_) * xRatio;
            g2d.drawImage(img, (int)x1, (int)y1, (int)x2, (int)y2, 0, 0, iww, ihh, this);
        }
        g2d.dispose();
    }

    protected BufferedImage paintNightShading(BufferedImage tempImage) {
        if (this.shadingEnabled_ && this.shadingOpacity_ > 0) {
            DayNightMap dnmap = new DayNightMap(tempImage, new LonLatEdges(this.srcLeft_, this.srcTop_, this.srcRight_, this.srcBottom_), tempImage.getWidth(), tempImage.getHeight());
            dnmap.setDarkness(this.shadingOpacity_);
            dnmap.setSubsolarPoint(this.subsolarLon_, this.subsolarLat_);
            dnmap.setBrightAngle(70.0);
            return dnmap.getMap();
        }
        return tempImage;
    }

    protected void drawOutlineOverlays(Graphics2D g2d, AbstractProjection projection) {
        for (int i = 0; i < 3; ++i) {
            if (this.overlays_[i] == null || !(this.overlays_[i] instanceof OutlineOverlay) || this.overlayWeights_[i] <= 0) continue;
            projection.setPathColor(this.overlayColors_[i]);
            projection.setPathStroke(this.overlayStrokes_[i]);
            projection.setPointSymbol(this.overlaySymbols_[i], (float)this.overlaySymbolSizes_[i]);
            projection.drawPath(g2d, (OutlineOverlay)this.overlays_[i]);
        }
    }

    protected void drawGridAndBorder(Graphics2D g2d, AbstractProjection projection, boolean borderVis) {
        if (this.gridStroke_ != null && this.gridSpacingLon_ > 0.0f && this.gridSpacingLat_ > 0.0f) {
            projection.setGridSpacing(this.gridSpacingLon_, this.gridSpacingLat_);
            projection.setLatGridOffset(this.gridOffsetLat_);
            projection.setGridColor(this.gridColor_);
            projection.setGridStroke(this.gridStroke_);
            projection.setGridLabeled(this.gridLabeled_);
            projection.setGridLabelStep(this.gridLabelStep_);
            projection.setGridFont(this.gridFont_);
            projection.drawGrid(g2d);
        } else {
            projection.setGridStroke(null);
        }
        if (borderVis) {
            projection.setBorderStroke(this.borderStroke_);
            projection.drawBorder(g2d);
        }
    }

    public PointLL transformXY2LL(int x, int y) {
        return this.transformXY2LL((double)x + 0.5, (double)y + 0.5);
    }

    public PointLL transformXY2LL(double x, double y) {
        if (x < 0.0 || y < 0.0 || x > (double)this.getWidth() || y > (double)this.getHeight()) {
            return null;
        }
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        return proj.transformXY2LL((int)x, (int)y);
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        PanPreferences prefs;
        boolean changeAll = pname == null || "all".equals(pname);
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj == null) {
            return;
        }
        if (changeAll || pname.contains("lonlat.proj.name") || pname.contains("lonlat.proj.lon0") || pname.contains("lonlat.proj.lat0") || pname.contains("lonlat.proj.xparam")) {
            this.updateLonLatEdges();
        }
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
            proj.setBackground(this.getBackground());
            proj.setBorderColor(this.getForeground());
        }
        int sfactor = this.pmeta_.getInt("size.factor");
        if (changeAll || pname.contains("grid.color") || pname.contains("grid.weight") || pname.contains("grid.style") || pname.contains("grid.spacing") || pname.contains("grid.spacing.lon") || pname.contains("grid.spacing.lat") || pname.contains("grid.offset.lat")) {
            if (pname.equals("grid.spacing")) {
                this.gridSpacingLat_ = this.gridSpacingLon_ = this.pmeta_.getFloat("grid.spacing");
            } else {
                this.gridSpacingLon_ = this.pmeta_.getFloat("grid.spacing.lon");
                this.gridSpacingLat_ = this.pmeta_.getFloat("grid.spacing.lat");
            }
            this.gridOffsetLat_ = this.pmeta_.getBoolean("grid.offset.lat");
            this.gridColor_ = this.pmeta_.getColor("grid.color");
            this.gridWeight_ = MathUtils.constrain0(200, this.pmeta_.getInt("grid.weight"));
            this.gridStroke_ = this.gridWeight_ > 0 ? PanGraphicUtils.buttMiterStroke(this.pmeta_.getString("grid.style"), this.gridWeight_, sfactor) : null;
        }
        if (changeAll || pname.contains("grid.label.step")) {
            this.gridLabelStep_ = MathUtils.constrain0(5, this.pmeta_.getInt("grid.label.step"));
            boolean bl = this.gridLabeled_ = this.gridLabelStep_ > 0;
        }
        if (changeAll || pname.contains("lonlat.border.weight")) {
            int sweight = MathUtils.constrain0(250, this.pmeta_.getInt("lonlat.border.weight"));
            this.borderStroke_ = PanGraphicUtils.squareMiterStroke(PanStrokePattern.SOLID, sweight, sfactor);
        }
        float scaling = 0.01f * (float)sfactor;
        float sqscaling = (float)Math.sqrt(scaling);
        if (changeAll || pname.startsWith("lonlat.overlay.")) {
            for (int i = 0; i < 3; ++i) {
                this.overlays_[i] = PanUtils.getOverlay(this.pmeta_.getString(PanParamKeys.OVERLAY_NAME[i]));
                this.overlayWeights_[i] = MathUtils.constrain0(400, this.pmeta_.getInt(PanParamKeys.OVERLAY_WGT[i]));
                this.overlayStrokes_[i] = PanGraphicUtils.roundStroke(this.pmeta_.getString(PanParamKeys.OVERLAY_STYLE[i]), this.overlayWeights_[i], sfactor);
                this.overlayColors_[i] = this.pmeta_.getColor(PanParamKeys.OVERLAY_COLOR[i]);
                this.overlayMaskInverted_[i] = this.pmeta_.getBoolean(PanParamKeys.OVERLAY_INVERT[i]);
                this.overlaySymbols_[i] = SymbolID.matching(this.pmeta_.getString(PanParamKeys.OVERLAY_SYMBOL_ID[i]));
                this.overlaySymbolSizes_[i] = this.pmeta_.getFloat(PanParamKeys.OVERLAY_SYMBOL_SIZE[i]) * sqscaling;
                this.overlaySymbolSizes_[i] = MathUtils.constrain(this.overlaySymbolSizes_[i], 2.0, 12.0);
            }
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("grid.label.size")) {
            String fn = this.pmeta_.getString("labels.font");
            float gfhgt = scaling * this.pmeta_.getFloat("grid.label.size");
            this.gridFont_ = null;
            if (gfhgt > 0.0f) {
                gfhgt = MathUtils.constrain(2.0f, 36.0f, gfhgt);
                this.gridFont_ = PanGraphicUtils.getFont(fn, gfhgt);
            }
        }
        if (changeAll || pname.contains("scale.tick.format")) {
            String s = this.pmeta_.getString("scale.tick.format");
            if (s == null) {
                throw new RuntimeException("Null format string");
            }
            this.scaleFormatter_ = new PrintfFormat(s);
        }
        if (changeAll || pname.contains("lonlat.proj.shading.vis") || pname.contains("lonlat.proj.shading.opacity") || pname.contains("lonlat.proj.subsolar.lon") || pname.contains("lonlat.proj.subsolar.lat")) {
            this.shadingEnabled_ = this.pmeta_.getBoolean("lonlat.proj.shading.vis");
            this.shadingOpacity_ = this.pmeta_.getInt("lonlat.proj.shading.opacity");
            this.subsolarLon_ = this.pmeta_.getDouble("lonlat.proj.subsolar.lon");
            this.subsolarLat_ = this.pmeta_.getDouble("lonlat.proj.subsolar.lat");
        }
        if ((prefs = PanPreferences.getSharedInstance()).getBoolean("beta:underlays")) {
            if (changeAll || pname.contains("beta.alpha.underlay")) {
                String uname = this.pmeta_.getString("beta.alpha.underlay");
                this.underlay_ = PanUtils.getUnderlay(uname);
            }
            if (changeAll || pname.contains("beta.alpha.enabled") || pname.contains("beta.alpha.method") || pname.contains("beta.alpha.lavel.1") || pname.contains("beta.alpha.lavel.2") || pname.contains("beta.alpha.knockout") || pname.contains("beta.alpha.underlay")) {
                if (this.pmeta_.getBoolean("beta.alpha.enabled") && this.underlay_ != null) {
                    this.alphaLevel1_ = this.pmeta_.getInt("beta.alpha.lavel.1");
                    this.alphaLevel2_ = this.pmeta_.getInt("beta.alpha.lavel.2");
                    this.alphaKnockout_ = this.pmeta_.getBoolean("beta.alpha.knockout");
                    this.alphaEnabled_ = this.alphaLevel1_ < 100 || this.alphaKnockout_;
                } else {
                    this.alphaLevel1_ = 100;
                    this.alphaLevel2_ = 100;
                    this.alphaKnockout_ = false;
                    this.alphaEnabled_ = false;
                }
                LOGGER.trace("alphaEnabled_ {}", (Object)this.alphaEnabled_);
            }
        }
    }

    public BufferedImage drawKmlIconImage(boolean knockout, boolean borderVis) {
        int w = this.getWidth();
        int h = this.getHeight();
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        EquirectangularRegional eqproj = new EquirectangularRegional(w, h);
        eqproj.setCenter((this.srcLeft_ + this.srcRight_) * 0.5, (this.srcBottom_ + this.srcTop_) * 0.5);
        eqproj.getWidthParam().setValue(this.srcRight_ - this.srcLeft_);
        eqproj.getHeightParam().setValue(this.srcTop_ - this.srcBottom_);
        if (knockout) {
            eqproj.setBackground(new Color(0x999999, true));
        } else {
            eqproj.setBackground(this.getBackground());
        }
        eqproj.setZoom(1.0);
        if (borderVis) {
            eqproj.setBorderColor(this.getForeground());
            eqproj.setBorderStroke(this.borderStroke_);
        } else {
            eqproj.setBorderStroke(null);
        }
        eqproj.setLonGridSpacing(proj.getLonGridSpacing());
        eqproj.setLatGridSpacing(proj.getLatGridSpacing());
        eqproj.setLatGridOffset(proj.getLatGridOffset());
        eqproj.setGridColor(proj.getGridColor());
        eqproj.setGridStroke(proj.getGridStroke());
        eqproj.setGridLabeled(proj.isGridLabeled());
        eqproj.setPathColor(proj.getPathColor());
        eqproj.setPathStroke(proj.getPathStroke());
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g2d = img.createGraphics();
        this.paintMap(g2d, false, eqproj, knockout, borderVis);
        g2d.dispose();
        return img;
    }

    public synchronized LonLatEdges getLonLatEdges() {
        return new LonLatEdges(this.srcLeft_, this.srcTop_, this.srcRight_, this.srcBottom_);
    }

    protected synchronized void updateLonLatEdges() {
        LonLatEdges bounds = this.pmeta_.getProjectionMeta().getBounds();
        this.srcLeft_ = bounds.getWest();
        this.srcTop_ = bounds.getNorth();
        this.srcRight_ = bounds.getEast();
        this.srcBottom_ = bounds.getSouth();
        if (this.srcLeft_ < -360.0) {
            this.srcLeft_ += 360.0;
            this.srcRight_ += 360.0;
        }
        if (this.srcLeft_ >= 360.0) {
            this.srcLeft_ -= 360.0;
            this.srcRight_ -= 360.0;
        }
        if (this.data_ instanceof PanDataLonLatGridded) {
            if (this.srcRight_ <= this.srcLeft_) {
                this.srcRight_ += 360.0;
            }
            PanDataLonLatGridded lldata = (PanDataLonLatGridded)this.data_;
            lldata.setLonLatEdges(bounds);
        }
    }
}

