/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.time.TimeFormatter;
import gov.nasa.giss.time.UnixTimeFormatter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanAxisTickFomatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NcAxis axis_;
    private String pattern_;
    private PrintfFormat basicFormatter_ = PrintfFormat.PFORMAT_1;

    public PanAxisTickFomatter(NcAxis ax) {
        this.axis_ = ax;
    }

    public NcAxis getAxis() {
        return this.axis_;
    }

    public String getUnitsStr() {
        return this.axis_.getUnitsString();
    }

    public String getPattern() {
        return this.pattern_;
    }

    public void setPattern(String pattern) {
        this.pattern_ = pattern;
        if (pattern == null) {
            LOGGER.debug("Pattern is null", (Object)pattern);
            throw new RuntimeException("Null format string");
        }
        if (this.pattern_.startsWith("%")) {
            this.basicFormatter_ = new PrintfFormat(pattern);
        } else if (this.axis_ instanceof NcTimeAxis) {
            TimeFormatter formatter = ((NcTimeAxis)this.axis_).getFormatter();
            if (formatter instanceof UnixTimeFormatter) {
                try {
                    ((UnixTimeFormatter)formatter).applyPattern(pattern);
                }
                catch (Exception exc) {
                    LOGGER.trace("Axis is UnixTimeFormatter but does not accept format {}, {}", (Object)pattern, (Object)exc.toString());
                }
            }
        } else {
            this.basicFormatter_ = new PrintfFormat(pattern);
        }
    }

    public String format(double val) {
        if (this.axis_ == null) {
            LOGGER.trace("Axis object is null");
        }
        if (this.pattern_.startsWith("%")) {
            return this.basicFormatter_.sprintfx(val);
        }
        if (this.axis_ instanceof NcTimeAxis) {
            return ((NcTimeAxis)this.axis_).formatValue(val);
        }
        return this.basicFormatter_.sprintfx(val);
    }

    public String formatRaw(double val) {
        if (this.axis_ == null) {
            LOGGER.trace("Axis object is null");
        }
        return PrintfFormat.PFORMAT_7G.sprintfx(val);
    }

    public boolean isFormattedTime() {
        if (this.axis_ instanceof NcTimeAxis) {
            TimeFormatter formatter = ((NcTimeAxis)this.axis_).getFormatter();
            return formatter instanceof UnixTimeFormatter;
        }
        return false;
    }
}

