/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.panoply.action.PanToggleSourcesEnhancedAction;
import gov.nasa.giss.panoply.action.PanToggleSourcesInfoAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanBookmarksPanel;
import gov.nasa.giss.panoply.sources.PanCatalogsPanel;
import gov.nasa.giss.panoply.sources.PanDnVPanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesPanel;
import gov.nasa.giss.panoply.ui.PanFrame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class PanViewSourcesMenu
extends PanMenu {
    private final JRadioButtonMenuItem miShowDatasets_;
    private final JRadioButtonMenuItem miShowCatalogs_;
    private final JRadioButtonMenuItem miShowBookmarks_;
    private final JRadioButtonMenuItem miGeoreferenced_;
    private final JRadioButtonMenuItem miPlottable_;
    private final JRadioButtonMenuItem miAllVars_;
    private final JCheckBoxMenuItem miToggleInfo_;
    private final JCheckBoxMenuItem miToggleEnhanced_;

    public PanViewSourcesMenu(PanFrame parent) {
        super(parent, "view-sources-menu");
        boolean parentIsSources = parent instanceof PanSourcesFrame;
        AbstractAction a1 = null;
        AbstractAction a2 = null;
        AbstractAction a3 = null;
        if (parentIsSources) {
            final PanSourcesFrame sframe = (PanSourcesFrame)parent;
            a1 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sframe.showSubpanel(PanSourcesFrame.Subpanel.DATASETS);
                }
            };
            a2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sframe.showSubpanel(PanSourcesFrame.Subpanel.CATALOGS);
                }
            };
            a3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sframe.showSubpanel(PanSourcesFrame.Subpanel.BOOKMARKS);
                }
            };
        }
        this.miShowDatasets_ = this.makeRadioButtonItemFromProperties("show-datasets", a1);
        this.miShowCatalogs_ = this.makeRadioButtonItemFromProperties("show-catalogs", a2);
        this.miShowBookmarks_ = this.makeRadioButtonItemFromProperties("show-bookmarks", a3);
        this.add(this.miShowDatasets_).setEnabled(parentIsSources);
        this.add(this.miShowCatalogs_).setEnabled(parentIsSources);
        this.add(this.miShowBookmarks_).setEnabled(parentIsSources);
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.miShowDatasets_);
        bgroup.add(this.miShowCatalogs_);
        bgroup.add(this.miShowBookmarks_);
        this.miShowDatasets_.setSelected(parentIsSources);
        this.addSeparator();
        a1 = null;
        a2 = null;
        a3 = null;
        if (parentIsSources) {
            a1 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanViewSourcesMenu.this.setVisibleVarClass(NcVarClass.GEOREF);
                }
            };
            a2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanViewSourcesMenu.this.setVisibleVarClass(NcVarClass.GRIDDABLE);
                }
            };
            a3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanViewSourcesMenu.this.setVisibleVarClass(NcVarClass.ALL);
                }
            };
        }
        this.miGeoreferenced_ = this.makeRadioButtonItemFromProperties("show-georeferenced-vars", a1);
        this.miPlottable_ = this.makeRadioButtonItemFromProperties("show-plottable-vars", a2);
        this.miAllVars_ = this.makeRadioButtonItemFromProperties("show-all-vars", a3);
        this.add(this.miGeoreferenced_).setEnabled(parentIsSources);
        this.add(this.miPlottable_).setEnabled(parentIsSources);
        this.add(this.miAllVars_).setEnabled(parentIsSources);
        bgroup = new ButtonGroup();
        bgroup.add(this.miGeoreferenced_);
        bgroup.add(this.miPlottable_);
        bgroup.add(this.miAllVars_);
        this.addSeparator();
        AbstractAction a = parentIsSources ? PanToggleSourcesInfoAction.getSharedInstance() : null;
        this.miToggleInfo_ = this.makeCheckBoxItemFromProperties("toggle-info", a);
        this.add(this.miToggleInfo_);
        a = parentIsSources ? PanToggleSourcesEnhancedAction.getSharedInstance() : null;
        this.miToggleEnhanced_ = this.makeCheckBoxItemFromProperties("toggle-enhanced-mode", a);
        this.add(this.miToggleEnhanced_);
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        boolean parentIsSources = this.pframe_ instanceof PanSourcesFrame;
        if (parentIsSources) {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            PanSourcesPanel vsp = ((PanSourcesFrame)this.pframe_).getVisibleSubpanel();
            boolean isDatasets = vsp instanceof PanDnVPanel;
            boolean isCatalogs = vsp instanceof PanCatalogsPanel;
            boolean isBookmarks = vsp instanceof PanBookmarksPanel;
            this.miShowDatasets_.setSelected(isDatasets);
            this.miShowCatalogs_.setSelected(isCatalogs);
            this.miShowBookmarks_.setSelected(isBookmarks);
            this.miGeoreferenced_.setEnabled(isDatasets);
            this.miPlottable_.setEnabled(isDatasets);
            this.miAllVars_.setEnabled(isDatasets);
            if (isDatasets) {
                String vclass = prefs.getString("sources:datasets.varclass");
                this.miGeoreferenced_.setSelected(NcVarClass.GEOREF.matches(vclass));
                this.miPlottable_.setSelected(NcVarClass.GRIDDABLE.matches(vclass));
                this.miAllVars_.setSelected(NcVarClass.ALL.matches(vclass));
            }
            if (this.miToggleInfo_ != null) {
                boolean isOn = prefs.getBoolean("sources:info.vis");
                this.miToggleInfo_.setEnabled(isDatasets || isCatalogs);
                this.miToggleInfo_.setSelected(isOn);
            }
            if (this.miToggleEnhanced_ != null) {
                boolean isOn = prefs.getBoolean("sources:info.enhanced");
                this.miToggleEnhanced_.setEnabled(isDatasets);
                this.miToggleEnhanced_.setSelected(isOn);
            }
        } else {
            int icount = this.getItemCount();
            for (int i = 0; i < icount; ++i) {
                JMenuItem jmi = this.getItem(i);
                if (jmi == null) continue;
                this.getItem(i).setEnabled(false);
            }
        }
    }

    private void setVisibleVarClass(NcVarClass vclass) {
        if (this.pframe_ instanceof PanSourcesFrame) {
            PanSourcesFrame sframe = (PanSourcesFrame)this.pframe_;
            PanDnVPanel dp = (PanDnVPanel)sframe.getSubpanel(PanSourcesFrame.Subpanel.DATASETS);
            dp.setVisibleVarClass(vclass);
            sframe.showSubpanel(PanSourcesFrame.Subpanel.DATASETS);
        }
    }
}

