/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.help;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.ui.PanZoomableFrame;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.BoxLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;

public final class PanHelpFrameJFX
extends PanZoomableFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String HELP_PATH = "resources/";
    private static final String START_PAGE = "index.html";
    private static final int INIT_WIDTH = 640;
    private static final int INIT_HEIGHT = 480;
    private static final int MIN_WIDTH = 200;
    private static final int MIN_HEIGHT = 200;
    private static final double MAX_ZOOM = 2.5;
    private static final double MIN_ZOOM = 0.4;
    private static WebView jfxWebView_;

    public static PanHelpFrameJFX getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanHelpFrameJFX() {
        super("Help");
        this.setName(this.getTitle());
        if (PlatformUtils.isWindows()) {
            this.setTitle("Panoply: " + this.getTitle());
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.setPanMenuBar(new PanMenuBar(this));
        this.createLayout();
        this.placeOnScreen();
    }

    private void createLayout() {
        String rpath = "resources/index.html";
        URL url = PanHelpFrameJFX.class.getResource("resources/index.html");
        JFXPanel jfxPanel = new JFXPanel();
        jfxPanel.setMinimumSize(new Dimension(640, 480));
        jfxPanel.setMinimumSize(new Dimension(200, 200));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add((Component)jfxPanel);
        contentPane.add(this.getStatusBar());
        Platform.runLater(() -> this.createWebView(jfxPanel, url));
        this.pack();
        this.setMinimumSize(new Dimension(640, 480));
    }

    private void createWebView(JFXPanel jfxPanel, URL url) {
        jfxWebView_ = new WebView();
        jfxWebView_.setContextMenuEnabled(false);
        jfxPanel.setScene(new Scene((Parent)jfxWebView_));
        final WebEngine engine = jfxWebView_.getEngine();
        engine.load(url.toString());
        ChangeListener<Worker.State> listener = new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    PanHelpFrameJFX.this.attachHyperlinkListeners(engine);
                }
            }
        };
        engine.getLoadWorker().stateProperty().addListener((ChangeListener)listener);
    }

    private void attachHyperlinkListeners(WebEngine engine) {
        EventListener listener = new EventListener(){

            @Override
            public void handleEvent(Event e) {
                EventTarget target = e.getCurrentTarget();
                HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                String href = anchorElement.getHref();
                if (href.matches("(http|https|ftp|file):.*")) {
                    e.preventDefault();
                    EventQueue.invokeLater(() -> {
                        try {
                            FileUtils.openBrowserURL(href);
                        }
                        catch (Exception exc) {
                            PanHelpFrameJFX.this.displayExcMessage(exc.toString());
                        }
                    });
                } else if (href.matches("(mailto):.*")) {
                    e.preventDefault();
                    EventQueue.invokeLater(() -> {
                        try {
                            FileUtils.openMailtoURL(href);
                        }
                        catch (Exception exc) {
                            PanHelpFrameJFX.this.displayExcMessage(exc.toString());
                        }
                    });
                }
            }
        };
        Document doc = engine.getDocument();
        NodeList lista = doc.getElementsByTagName("a");
        for (int i = 0; i < lista.getLength(); ++i) {
            ((EventTarget)((Object)lista.item(i))).addEventListener("click", listener, false);
        }
    }

    @Override
    public void doLayout() {
        if (this.getWidth() < 200 || this.getHeight() < 200) {
            int w = Math.max(this.getWidth(), 200);
            int h = Math.max(this.getHeight(), 200);
            this.setSize(new Dimension(w, h));
        }
        super.doLayout();
    }

    public void setPage(String fname) {
        URL url = PanHelpFrameJFX.class.getResource(HELP_PATH + fname);
        try {
            this.setPage(url);
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.displayExcMessage(exc.toString());
        }
    }

    public void setPage(URL url) {
        Platform.runLater(() -> jfxWebView_.getEngine().load(url.toString()));
    }

    private void displayExcMessage(String excMessage) {
        Platform.runLater(() -> jfxWebView_.getEngine().loadContent("<html><head><title>Error</title><head><body><p>Could not load page.</p><pre>" + excMessage + "</pre></body></html>"));
    }

    @Override
    public boolean canZoomIn() {
        if (jfxWebView_ == null) {
            return false;
        }
        double zoom = jfxWebView_.getZoom();
        return zoom < 2.5;
    }

    @Override
    public boolean canZoomOut() {
        if (jfxWebView_ == null) {
            return false;
        }
        double zoom = jfxWebView_.getZoom();
        return zoom > 0.4;
    }

    @Override
    public void zoomReset() {
        Platform.runLater(() -> jfxWebView_.setZoom(1.0));
    }

    @Override
    public void zoomIn() {
        double zoom = Math.min(2.5, jfxWebView_.getZoom() + 0.1);
        Platform.runLater(() -> jfxWebView_.setZoom(zoom));
    }

    @Override
    public void zoomOut() {
        double zoom = Math.max(0.4, jfxWebView_.getZoom() - 0.1);
        Platform.runLater(() -> jfxWebView_.setZoom(zoom));
    }

    @Override
    public void resizeToFitDisplay() {
        this.pack();
        this.repaint();
    }

    private static class Singleton {
        private static final PanHelpFrameJFX INSTANCE = new PanHelpFrameJFX();

        private Singleton() {
        }
    }
}

