/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLatVert;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridderLatVert;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import java.awt.Dimension;

public class PanDataLatVert
extends PanDataGeneral2D {
    public PanDataLatVert(NcArray nca, Dimension size) {
        this(nca, size.width, size.height);
    }

    public PanDataLatVert(NcArray nca, int width, int height) {
        super(nca, width, height);
        this.setGridLeftAndRight(-90.0, 90.0);
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayLatVert)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayLatVert.");
        }
        return true;
    }

    @Override
    public String getXAxisName() {
        return "Latitude";
    }

    @Override
    public String getXAxisUnits() {
        return "degree_north";
    }

    @Override
    protected void regrid(NcArray nca, double[] target, boolean interpolated) {
        NcGridderLatVert gridder = (NcGridderLatVert)nca.getGridder();
        if (this.yaxisMethod_ == PanAxisMethod.INDEX) {
            gridder.setYAxisMethod(NcAxisMethod.INDEX);
        } else if (this.yaxisMethod_ == PanAxisMethod.LOG10) {
            gridder.setYAxisUcarUnits(this.yAxisUcarUnits_);
            gridder.setYAxisMethod(NcAxisMethod.LOG10);
        } else {
            gridder.setYAxisUcarUnits(this.yAxisUcarUnits_);
            gridder.setYAxisMethod(NcAxisMethod.SCALAR);
        }
        gridder.setSize(this.gridWidth_, this.gridHeight_);
        gridder.setBounds(this.lBound_, this.tBound_, this.rBound_, this.bBound_);
        if (interpolated) {
            gridder.regridInterpolate(nca, target);
        } else {
            gridder.regridNoInterpolate(nca, target);
        }
    }
}

