/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.GPrintable;
import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.img.ImageUtils;
import gov.nasa.giss.panoply.cl.PCLVariable;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.io.PanImageUtils;
import gov.nasa.giss.panoply.io.PanKmzUtils;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotUtils;
import gov.nasa.giss.panoply.util.PanConstants;
import gov.nasa.giss.panoply.util.PanKmlOption;
import gov.nasa.giss.panoply.util.PanPlotOutputFormat;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanUtils;
import java.awt.Color;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCLPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanPlotMeta pmeta_;

    private PCLPlot(PanPlotMeta pmeta) {
        this.pmeta_ = pmeta;
    }

    public static PCLPlot createGeoreferencedPlot(String ptypeStr, PCLVariable clvar) {
        PanPlotType ptype = PanPlotType.matching(ptypeStr);
        if (ptype == null) {
            throw new IllegalArgumentException("Unknown plot type '" + ptypeStr + "'");
        }
        PanPlotMeta pmeta = null;
        switch (ptype) {
            case LON_LAT: {
                pmeta = new PanPlotMeta(ptype, 120);
                break;
            }
            case TIME_LAT: 
            case LAT_TIME: 
            case LON_TIME: 
            case LAT_VERT: 
            case LON_VERT: 
            case TIME_VERT: {
                pmeta = new PanPlotMeta(ptype, 120);
                break;
            }
            case LL_ZONAL: {
                pmeta = new PanPlotMeta(ptype, 120);
                break;
            }
            case LL_TRAJ: {
                pmeta = new PanPlotMeta(ptype, 120);
                break;
            }
            default: {
                throw new IllegalArgumentException("Plot type is not one that PanoplyCL is coded for.");
            }
        }
        PanData data = pmeta.createData(clvar.getNcVariable());
        data.getMinValue();
        pmeta.createPlot();
        return new PCLPlot(pmeta);
    }

    public static PCLPlot createGenericCCPlot(String ptypeStr, PCLVariable clvar, Object xaxisInfo, Object yaxisInfo) {
        PanPlotType ptype = PanPlotType.matching(ptypeStr);
        if (ptype == null) {
            throw new IllegalArgumentException("Unknown plot type '" + ptypeStr + "'");
        }
        if (ptype != PanPlotType.COLOR_CONTOUR) {
            throw new IllegalArgumentException("Plot type is not generic color contour.");
        }
        PanPlotMeta pmeta = new PanPlotMeta(ptype, 120);
        PanData data = pmeta.createData(clvar.getNcVariable(), xaxisInfo, yaxisInfo);
        data.getMinValue();
        pmeta.createPlot();
        return new PCLPlot(pmeta);
    }

    public static PCLPlot createLinePlot(String ptypeStr, PCLVariable clvar, Object axisInfo) {
        PanPlotType ptype = PanPlotType.matching(ptypeStr);
        if (ptype == null) {
            throw new IllegalArgumentException("Unknown plot type '" + ptypeStr + "'");
        }
        if (!ptype.isLinePlot()) {
            throw new IllegalArgumentException("Plot type must be a line plot.");
        }
        PanPlotMeta pmeta = new PanPlotMeta(ptype, 120);
        PanData data = pmeta.createData(clvar.getNcVariable(), axisInfo);
        data.getMinValue();
        pmeta.createPlot();
        return new PCLPlot(pmeta);
    }

    public boolean set(String key, Object xvalue) throws ParseException {
        String svalue;
        Objects.requireNonNull(key, "Plot option key cannot be null.");
        String string = svalue = xvalue == null ? null : xvalue.toString();
        if (xvalue == null) {
            LOGGER.trace("set {}, null", (Object)key, (Object)null);
        } else {
            LOGGER.trace("set {}, {}, {}", key, svalue, xvalue.getClass());
        }
        PanPlotType ptype = this.pmeta_.getType();
        Object skey = key.replaceAll("\\-", ".");
        if (ptype.isLonLatMap()) {
            if (((String)skey).equals("grid.spacing")) {
                this.set("grid.spacing.lon", svalue);
                return this.set("grid.spacing.lat", svalue);
            }
            if (ptype.isLonLatMap() && ((String)skey).matches("(proj|center|border|overlay|numbers|shading).*")) {
                skey = "lonlat." + (String)skey;
            }
        }
        if (!this.pmeta_.containsKey(skey) && !((String)skey).contains("lonlat.proj.xparam")) {
            LOGGER.warn("{} is not a known key for this plot type.", skey);
            return false;
        }
        Object ovalue = this.pmeta_.get((String)skey);
        if (((String)skey).contains("lonlat.proj.xparam")) {
            PanPlot plot = this.pmeta_.getPlot();
            if (plot != null) {
                this.pmeta_.set((String)skey, svalue);
            }
        } else {
            if (ovalue == null) {
                return false;
            }
            if (ovalue instanceof String) {
                this.pmeta_.setString((String)skey, svalue);
                return true;
            }
            if (ovalue instanceof Boolean) {
                try {
                    LOGGER.trace("setBoolean {}, {}", skey, (Object)svalue);
                    if (xvalue instanceof Boolean) {
                        this.pmeta_.setBoolean((String)skey, (Boolean)xvalue);
                    } else {
                        this.pmeta_.setBoolean((String)skey, svalue);
                    }
                    return true;
                }
                catch (Exception exc) {
                    LOGGER.error("Could not parse '{}' as a boolean for key {}.", (Object)svalue, (Object)key);
                    throw new ParseException("Could not parse '" + svalue + "' as a boolean for key " + key, -1);
                }
            }
            if (ovalue instanceof Color) {
                try {
                    this.pmeta_.setColor((String)skey, svalue);
                    return true;
                }
                catch (Exception exc) {
                    LOGGER.error("Could not parse '{}' as a color for key {}.", (Object)svalue, (Object)key);
                    throw new ParseException("Could not parse '" + svalue + "' as a color for key " + key, -1);
                }
            }
            if (ovalue instanceof Double) {
                try {
                    LOGGER.trace("setDouble {}, {}", skey, (Object)svalue);
                    if (xvalue instanceof Double) {
                        this.pmeta_.setDouble((String)skey, (Double)xvalue);
                    } else {
                        this.pmeta_.setDouble((String)skey, svalue);
                    }
                    return true;
                }
                catch (Exception exc) {
                    LOGGER.error("Could not parse '{}' as a double for key {}.", (Object)svalue, (Object)key);
                    throw new ParseException("Could not parse '" + svalue + "' as a double for key " + key, -1);
                }
            }
            if (ovalue instanceof Float) {
                try {
                    LOGGER.trace("setFloat {}, {}", skey, (Object)svalue);
                    if (xvalue instanceof Float) {
                        this.pmeta_.setFloat((String)skey, ((Float)xvalue).floatValue());
                    } else {
                        this.pmeta_.setFloat((String)skey, svalue);
                    }
                    return true;
                }
                catch (Exception exc) {
                    LOGGER.error("Could not parse '{}' as a float for key {}.", (Object)svalue, (Object)key);
                    throw new ParseException("Could not parse '" + svalue + "' as a float for key " + key, -1);
                }
            }
            if (ovalue instanceof Integer) {
                try {
                    LOGGER.trace("setInt {}, {}", skey, (Object)svalue);
                    if (xvalue instanceof Integer) {
                        this.pmeta_.setInt((String)skey, (Integer)xvalue);
                    } else {
                        this.pmeta_.setInt((String)skey, svalue);
                    }
                    return true;
                }
                catch (Exception exc) {
                    LOGGER.error("Could not parse '{}' as an integer for key {}.", (Object)svalue, (Object)key);
                    throw new ParseException("Could not parse '" + svalue + "' as an integer for key " + key, -1);
                }
            }
            if (ovalue instanceof AbstractColorTable) {
                AbstractColorTable ct = PanUtils.getColorTable(svalue);
                if (ct == null) {
                    LOGGER.warn("No color table matching '{}'.", (Object)svalue);
                    return false;
                }
                this.pmeta_.set((String)skey, ct);
                return true;
            }
            LOGGER.warn("Cannot convert '{}' to a {}.", (Object)key, (Object)ovalue.getClass());
            return false;
        }
        return false;
    }

    public boolean setVariable(int index, PCLVariable pv) {
        int xindex = index - 1;
        NcVariable ncv = pv.getNcVariable();
        try {
            NcArray nca = PanPlotUtils.createCompatibleArray(ncv, this.pmeta_);
            this.pmeta_.setNcArray(xindex, nca, null);
        }
        catch (Exception exc) {
            LOGGER.error("Could not add variable to plot: {}.", exc);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            System.exit(2);
        }
        return true;
    }

    public boolean setVarDimension(int dimid, int dimset) {
        int xdimid = dimid - 1;
        int xdimset = dimset;
        if (xdimset > 0) {
            --xdimset;
        }
        try {
            this.pmeta_.setDataSlice(0, xdimid, xdimset, null);
        }
        catch (Exception exc) {
            String s = exc.toString().replaceFirst(".*Exception\\: ", "");
            LOGGER.error("Bad dimension setting: {}", (Object)s);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            System.exit(1);
        }
        return true;
    }

    public boolean setVarDimension(int varid, int dimid, int dimset) {
        int xvarid = varid - 1;
        int xdimid = dimid - 1;
        int xdimset = dimset;
        if (xdimset > 0) {
            --xdimset;
        }
        try {
            this.pmeta_.setDataSlice(xvarid, xdimid, xdimset, null);
        }
        catch (Exception exc) {
            String s = exc.toString().replaceFirst(".*Exception\\: ", "");
            LOGGER.error("Bad dimension setting: {}", (Object)s);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            System.exit(1);
        }
        return true;
    }

    public boolean stepDimension(int ... dimsets) {
        PanData data = this.pmeta_.getData();
        try {
            NcArray nca;
            NcArray ncArray = nca = dimsets.length == 2 ? data.getArray(dimsets[0]) : data.getArray(0);
            if (dimsets.length == 2) {
                int current = nca.getSliceIndex(dimsets[1]);
                this.pmeta_.setDataSlice(dimsets[0], dimsets[1], current + 1, null);
            } else if (dimsets.length == 1) {
                int current = nca.getSliceIndex(dimsets[0]);
                this.pmeta_.setDataSlice(0, dimsets[0], current + 1, null);
            } else {
                int current = nca.getSliceIndex(0) + 1;
                this.pmeta_.setDataSlice(0, 0, current + 1, null);
            }
        }
        catch (Exception exc) {
            LOGGER.error("Bad dimension setting: {}", exc);
            return false;
        }
        return true;
    }

    public double getDataMinimum() {
        return this.pmeta_.getScaleMeta().getDataMinimum();
    }

    public double getDataMaximum() {
        return this.pmeta_.getScaleMeta().getDataMaximum();
    }

    public boolean saveImage(String format, String fname) {
        String country = Locale.getDefault().getCountry();
        if (country != null && (country.equals(Locale.US.getCountry()) || country.equals(Locale.CANADA.getCountry()))) {
            return this.saveImage(format, fname, false, PaperSize.LETTER.name());
        }
        return this.saveImage(format, fname, false, PaperSize.A4.name());
    }

    public boolean saveImage(String format, String fname, boolean vectorized, String paperSize) {
        PanPlotOutputFormat ppof = PanPlotOutputFormat.matching(format);
        if (ppof == null) {
            LOGGER.error("Could not match image format '{}'", (Object)format);
            LOGGER.error("Image will not be saved.");
            return false;
        }
        long start = System.currentTimeMillis();
        LOGGER.trace("Saving image {} as {}.", (Object)fname, (Object)ppof);
        File f = null;
        try {
            f = new File(fname);
        }
        catch (Exception exc) {
            LOGGER.error("Could not save plot: {}", exc);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return Boolean.FALSE;
        }
        PanPlot plot = this.pmeta_.getPlot();
        this.pmeta_.getLayout().get("size.pixels");
        boolean success = false;
        try {
            switch (ppof) {
                case GIF: {
                    success = ImageUtils.saveAsGif(f, plot);
                    break;
                }
                case JPEG: {
                    success = ImageUtils.saveAsJpeg(f, plot);
                    break;
                }
                case PNG: {
                    success = ImageUtils.saveAsPng(f, plot);
                    break;
                }
                case TIFF: {
                    success = ImageUtils.saveAsTiff(f, plot, PanConstants.SOFTWARE);
                    break;
                }
                case PDF: {
                    success = PanImageUtils.saveAsPdf(f, (GPrintable)plot, vectorized, paperSize);
                    break;
                }
                case PS: {
                    success = PanImageUtils.saveAsPs(f, (GPrintable)plot, vectorized, paperSize);
                    break;
                }
                default: {
                    LOGGER.debug("Switch default case: How did we get here? {}", (Object)ppof);
                    break;
                }
            }
        }
        catch (Exception exc) {
            LOGGER.error("Could not save plot due to exception: {}", exc);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return false;
        }
        LOGGER.trace("save {}, time {} ms", (Object)success, (Object)(System.currentTimeMillis() - start));
        return success;
    }

    public boolean saveAsKmz(String fname, boolean includeColorbar, boolean knockout, boolean includeBorder) {
        LOGGER.trace("Exporting KMZ {}.", (Object)fname);
        if (!this.pmeta_.getType().isLonLatMap()) {
            LOGGER.error("Plot must be lon-lat map plot.");
            return false;
        }
        if (fname == null || fname.isEmpty()) {
            LOGGER.error("Could not export KMZ due to empty filename input.");
            return false;
        }
        Hashtable<PanKmlOption, Object> opts = new Hashtable<PanKmlOption, Object>(12);
        opts.put(PanKmlOption.BORDER, includeBorder);
        opts.put(PanKmlOption.KNOCKOUT, knockout);
        opts.put(PanKmlOption.COLORBAR, includeColorbar);
        File f = null;
        try {
            f = new File(fname);
        }
        catch (Exception exc) {
            LOGGER.error("Could not export KMZ due to file init error: {}.", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return Boolean.FALSE;
        }
        PanLonLatPlot llplot = (PanLonLatPlot)this.pmeta_.getPlot();
        try {
            PanKmzUtils.save(f, llplot, opts);
        }
        catch (Exception exc) {
            LOGGER.error("Could not export KMZ due to error: {}.", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean close() {
        this.pmeta_.flush();
        this.pmeta_ = null;
        return true;
    }
}

