/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action.dialog;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcDiscreteVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.ui.PanCommonComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanCreatePlotOption;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.VariableDS;

public class PanCreatePlotDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanRadioButton georefBtn_;
    private PanRadioButton featureBtn_;
    private PanRadioButton zonalBtn_;
    private PanRadioButton common2DBtn_;
    private PanRadioButton lineBtn_;
    private PanEnumComboBox geoAxesCombo_;
    private PanEnumComboBox featureCombo_;
    private PanEnumComboBox zonalCombo_;
    private PanCommonComboBox twoDXAxisCombo_;
    private PanCommonComboBox twoDYAxisCombo_;
    private PanStringComboBox linePlotDirCombo_;
    private PanCommonComboBox linePlotAxisCombo_;
    private JButton cancelBtn_;
    private JButton createBtn_;
    private boolean success_;

    public PanCreatePlotDialog(PanFrame ff, NcVariable ncvar) {
        super(ff, "Create Plot", true);
        this.setResizable(false);
        this.createLayout(ncvar);
        this.attachListeners();
        Rectangle rr = ff.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private void createLayout(NcVariable ncvar) {
        Object dx;
        NcDimension[] dims = ncvar.getNumericDimensions();
        ArrayList<AxisWrapper> axWrappers = new ArrayList<AxisWrapper>();
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] == null || dims[i].getLength() <= 1) continue;
            axWrappers.add(new AxisWrapper(i, dims[i]));
        }
        NcVarType varType = ncvar.getVarType();
        LOGGER.trace("varType {}", (Object)varType);
        if (varType instanceof NcDiscreteVarType && ((NcDiscreteVarType)varType).isTrajectory()) {
            LOGGER.trace("varType is trajectory");
            VariableDS tvarDS = NcVarUtils.getTrajectoryTimeVar(ncvar);
            LOGGER.trace("Got traj time var {}", (Object)(tvarDS != null ? 1 : 0));
            axWrappers.add(new AxisWrapper(-1, tvarDS));
        }
        Collections.sort(axWrappers);
        MultiLineLabel message = new MultiLineLabel("More than one type of plot can be created from the variable '" + ncvar.getName() + "'. What type would you like to create?", 100, 2);
        int maxWidth = message.getPreferredSize().width;
        QuickBox georefBox = null;
        QuickBox common2DBox = null;
        QuickBox lineplotBox = null;
        QuickBox featureBox = null;
        QuickBox zonalBox = null;
        if (ncvar.isGriddable2DGeo()) {
            this.georefBtn_ = PanRadioButton.create("Georeferenced", true);
            this.geoAxesCombo_ = PanEnumComboBox.create(PanPlotType.class);
            this.geoAxesCombo_.removeAllItems();
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LAT_TIME);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LAT, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LAT_VERT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_LAT);
                this.geoAxesCombo_.setSelectedItem(PanPlotType.LON_LAT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.TIME)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_TIME);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_VERT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.TIME_LAT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.TIME_VERT);
            }
            georefBox = QuickBox.createLeftBox(this.georefBtn_, this.geoAxesCombo_, PanLabel.create("color contour plot"));
            maxWidth = Math.max(maxWidth, georefBox.getPreferredSize().width);
        }
        if (ncvar.isGriddable2DGeo() && ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.LAT)) {
            this.zonalBtn_ = PanRadioButton.create("Georeferenced", true);
            this.zonalCombo_ = PanEnumComboBox.create(PanPlotType.class);
            this.zonalCombo_.removeAllItems();
            this.zonalCombo_.addItem(PanPlotType.LL_ZONAL);
            zonalBox = QuickBox.createLeftBox(this.zonalBtn_, this.zonalCombo_, PanLabel.create("line plot"));
            maxWidth = Math.max(maxWidth, zonalBox.getPreferredSize().width);
        }
        if (ncvar.isTrajectory()) {
            this.featureBtn_ = PanRadioButton.create("Georeferenced", true);
            this.featureCombo_ = PanEnumComboBox.create(PanPlotType.class);
            this.featureCombo_.removeAllItems();
            this.featureCombo_.addItem(PanPlotType.LL_TRAJ);
            featureBox = QuickBox.createLeftBox(this.featureBtn_, this.featureCombo_, PanLabel.create("plot"));
            maxWidth = Math.max(maxWidth, featureBox.getPreferredSize().width);
        }
        if (ncvar.isGriddable2D()) {
            this.common2DBtn_ = PanRadioButton.create("Color contour plot using", true);
            this.twoDXAxisCombo_ = PanCommonComboBox.create();
            this.twoDYAxisCombo_ = PanCommonComboBox.create();
            for (AxisWrapper axWrap : axWrappers) {
                this.twoDXAxisCombo_.addItem(axWrap);
                this.twoDYAxisCombo_.addItem(axWrap);
            }
            this.twoDXAxisCombo_.setSelectedIndex(0);
            this.twoDYAxisCombo_.setSelectedIndex(1);
            dx = this.twoDXAxisCombo_.getPreferredSize();
            Dimension dy = this.twoDYAxisCombo_.getPreferredSize();
            if (((Dimension)dx).width > 180) {
                ((Dimension)dx).width = 172;
                this.twoDXAxisCombo_.setPreferredSize((Dimension)dx);
                this.twoDXAxisCombo_.setMaximumSize((Dimension)dx);
                this.twoDXAxisCombo_.setMinimumSize((Dimension)dx);
            }
            if (dy.width > 180) {
                dy.width = 172;
                this.twoDYAxisCombo_.setPreferredSize((Dimension)dx);
                this.twoDYAxisCombo_.setMaximumSize((Dimension)dx);
                this.twoDYAxisCombo_.setMinimumSize((Dimension)dx);
            }
            common2DBox = QuickBox.createLeftBox(this.common2DBtn_, this.twoDXAxisCombo_, PanLabel.create("for X axis and"), this.twoDYAxisCombo_, PanLabel.create("for Y axis"));
            maxWidth = Math.max(maxWidth, common2DBox.getPreferredSize().width);
        }
        this.lineBtn_ = PanRadioButton.create("Line plot using", false);
        this.linePlotAxisCombo_ = PanCommonComboBox.create();
        for (AxisWrapper axWrap : axWrappers) {
            this.linePlotAxisCombo_.addItem(axWrap);
        }
        dx = this.linePlotAxisCombo_.getPreferredSize();
        if (((Dimension)dx).width > 180) {
            ((Dimension)dx).width = 172;
            this.linePlotAxisCombo_.setPreferredSize((Dimension)dx);
            this.linePlotAxisCombo_.setMaximumSize((Dimension)dx);
            this.linePlotAxisCombo_.setMinimumSize((Dimension)dx);
        }
        this.linePlotDirCombo_ = PanStringComboBox.create();
        this.linePlotDirCombo_.addItem("horizontal");
        this.linePlotDirCombo_.addItem("vertical");
        lineplotBox = QuickBox.createLeftBox(this.lineBtn_, this.linePlotAxisCombo_, PanLabel.create("for the"), this.linePlotDirCombo_, PanLabel.create("axis"));
        maxWidth = Math.max(maxWidth, lineplotBox.getPreferredSize().width);
        ButtonGroup plotChoices = new ButtonGroup();
        if (this.lineBtn_ != null) {
            plotChoices.add(this.lineBtn_);
            this.lineBtn_.setSelected(true);
        }
        if (this.common2DBtn_ != null) {
            plotChoices.add(this.common2DBtn_);
            this.common2DBtn_.setSelected(true);
        }
        if (this.featureBtn_ != null) {
            plotChoices.add(this.featureBtn_);
            this.featureBtn_.setSelected(true);
        }
        if (this.zonalBtn_ != null) {
            plotChoices.add(this.zonalBtn_);
            this.zonalBtn_.setSelected(true);
        }
        if (this.georefBtn_ != null) {
            plotChoices.add(this.georefBtn_);
            this.georefBtn_.setSelected(true);
        }
        this.cancelBtn_ = new JButton("Cancel");
        this.createBtn_ = new JButton("Create");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelBtn_, this.createBtn_) : QuickBox.createRightBox(this.createBtn_, this.cancelBtn_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(2, 10, 0, 2);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        int row = 0;
        contentPanel.add((Component)message, new FGConstraint(0, row));
        ++row;
        ++row;
        if (georefBox != null) {
            contentPanel.add((Component)georefBox, new FGConstraint(0, ++row));
        }
        if (zonalBox != null) {
            contentPanel.add((Component)zonalBox, new FGConstraint(0, ++row));
        }
        if (featureBox != null) {
            contentPanel.add((Component)featureBox, new FGConstraint(0, ++row));
        }
        if (common2DBox != null) {
            contentPanel.add((Component)common2DBox, new FGConstraint(0, ++row));
        }
        if (lineplotBox != null) {
            contentPanel.add((Component)lineplotBox, new FGConstraint(0, ++row));
        }
        ++row;
        ++row;
        contentPanel.add((Component)buttonBox, new FGConstraint(0, ++row, 1.0));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.createBtn_);
        this.pack();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            EventQueue.invokeLater(() -> this.createBtn_.requestFocusInWindow());
        }
        super.setVisible(vis);
    }

    private void attachListeners() {
        ItemListener il;
        if (this.georefBtn_ != null) {
            this.geoAxesCombo_.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.georefBtn_.setSelected(true);
            });
        }
        if (this.zonalBtn_ != null) {
            this.zonalCombo_.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.zonalBtn_.setSelected(true);
            });
        }
        if (this.featureBtn_ != null) {
            this.featureCombo_.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.featureBtn_.setSelected(true);
            });
        }
        if (this.common2DBtn_ != null) {
            il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    PanCreatePlotDialog.this.common2DBtn_.setSelected(true);
                    int x = PanCreatePlotDialog.this.twoDXAxisCombo_.getSelectedIndex();
                    int y = PanCreatePlotDialog.this.twoDYAxisCombo_.getSelectedIndex();
                    if (x == y) {
                        Object source = e.getSource();
                        if (source == PanCreatePlotDialog.this.twoDXAxisCombo_) {
                            if (y == 0) {
                                PanCreatePlotDialog.this.twoDYAxisCombo_.setSelectedIndex(1);
                            } else {
                                PanCreatePlotDialog.this.twoDYAxisCombo_.setSelectedIndex(0);
                            }
                        } else if (x == 0) {
                            PanCreatePlotDialog.this.twoDXAxisCombo_.setSelectedIndex(1);
                        } else {
                            PanCreatePlotDialog.this.twoDXAxisCombo_.setSelectedIndex(0);
                        }
                    }
                }
            };
            this.twoDXAxisCombo_.addItemListener(il);
            this.twoDYAxisCombo_.addItemListener(il);
        }
        if (this.lineBtn_ != null) {
            il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    PanCreatePlotDialog.this.lineBtn_.setSelected(true);
                }
            };
            this.linePlotDirCombo_.addItemListener(il);
            this.linePlotAxisCombo_.addItemListener(il);
        }
        this.createBtn_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelBtn_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public Hashtable<PanCreatePlotOption, Object> getOptions() {
        Hashtable<PanCreatePlotOption, Object> opts = new Hashtable<PanCreatePlotOption, Object>();
        if (this.georefBtn_ != null && this.georefBtn_.isSelected()) {
            opts.put(PanCreatePlotOption.PLOT_TYPE, this.geoAxesCombo_.getSelectedItem());
        } else if (this.zonalBtn_ != null && this.zonalBtn_.isSelected()) {
            opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.LL_ZONAL);
        } else if (this.featureBtn_ != null && this.featureBtn_.isSelected()) {
            opts.put(PanCreatePlotOption.PLOT_TYPE, this.featureCombo_.getSelectedItem());
        } else if (this.common2DBtn_ != null && this.common2DBtn_.isSelected()) {
            AxisWrapper axWrap1 = (AxisWrapper)this.twoDXAxisCombo_.getSelectedItem();
            AxisWrapper axWrap2 = (AxisWrapper)this.twoDYAxisCombo_.getSelectedItem();
            int idx1 = axWrap1.getDimensionIndex();
            int idx2 = axWrap2.getDimensionIndex();
            opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.COLOR_CONTOUR);
            opts.put(PanCreatePlotOption.AXIS_INFO_1, idx1);
            opts.put(PanCreatePlotOption.AXIS_INFO_2, idx2);
        } else if (this.lineBtn_ != null && this.lineBtn_.isSelected()) {
            AxisWrapper axWrap = (AxisWrapper)this.linePlotAxisCombo_.getSelectedItem();
            Object axObject = axWrap.getObject();
            if (((String)this.linePlotDirCombo_.getSelectedItem()).equals("horizontal")) {
                opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.HORZ_LINE);
                opts.put(PanCreatePlotOption.AXIS_INFO_1, axObject);
            } else {
                opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.VERT_LINE);
                opts.put(PanCreatePlotOption.AXIS_INFO_1, axObject);
            }
        }
        return opts;
    }

    class AxisWrapper
    implements Comparable<AxisWrapper> {
        private int dimIndex_;
        private Object object_;
        private String name_;

        AxisWrapper(int index, Object object) {
            this.dimIndex_ = index;
            this.object_ = object;
            if (object instanceof NcDimension) {
                this.name_ = ((NcDimension)object).getName();
                if (this.name_ == null || this.name_.isEmpty()) {
                    this.name_ = index + 1 + " / " + ((NcDimension)object).getLength();
                }
            } else if (object instanceof VariableDS) {
                this.name_ = ((VariableDS)object).getShortName();
                if (this.name_ == null) {
                    throw new RuntimeException("Object is VariableDS without name");
                }
            } else {
                throw new IllegalArgumentException("Object must be NcDimension or VariableDS");
            }
        }

        int getDimensionIndex() {
            return this.dimIndex_;
        }

        Object getObject() {
            return this.object_;
        }

        public String toString() {
            return this.name_;
        }

        @Override
        public int compareTo(AxisWrapper o) {
            return this.name_.compareTo(o.toString());
        }
    }
}

