/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanToggleSourcesInfoAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private boolean busy_;
    private long last_;

    public static PanToggleSourcesInfoAction getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanToggleSourcesInfoAction() {
        super(PanProperties.SOURCES_PROPS.getString("toggle-info"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        boolean oldval = PREFS.getBoolean("sources:info.vis");
        long now = System.currentTimeMillis();
        if (now - this.last_ >= 200L || !(e.getSource() instanceof JCheckBoxMenuItem)) {
            PREFS.setBoolean("sources:info.vis", !oldval);
            PanSourcesFrame sf = PanSourcesFrame.getSharedInstance();
            sf.remakeLayout();
            sf.refresh();
        }
        GuiUtils.refreshFrontFrameMenuBar();
        this.last_ = now;
        this.busy_ = false;
    }

    private static class Singleton {
        private static final PanToggleSourcesInfoAction INSTANCE = new PanToggleSourcesInfoAction();

        private Singleton() {
        }
    }
}

