/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcCatalogDataset;
import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanOpenCatalogDatasetAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSourcesFrame parent_;

    public PanOpenCatalogDatasetAction(PanSourcesFrame parent) {
        super(PanProperties.SOURCES_PROPS.getString("open-catalog-data"));
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null) {
            return;
        }
        if (!(node instanceof NcCatalogNode)) {
            LOGGER.warn("Trying to open catalog dataset from non-NcCatalogNode");
            return;
        }
        if (!(node instanceof NcCatalogDataset)) {
            return;
        }
        URI uri = ((NcCatalogDataset)node).getURI();
        if (uri == null) {
            return;
        }
        try {
            PanFileUtils.openDataset(uri.toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

