/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.action.task.PanExportTextTask;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class PanExportTextAction
extends AbstractAction {
    private static final String TXT_EXT = "txt";
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-text");
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private final PanSourcesFrame parent_;

    public PanExportTextAction(PanSourcesFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] options;
        long mega;
        String message;
        int choice;
        TreeTableNode node = this.parent_.getSelectedNode();
        if (!(node instanceof NcVariable)) {
            return;
        }
        NcVariable ncvar = (NcVariable)node;
        long count = ncvar.getElementCount();
        if (PREFS.getBoolean("files:save.export.warning") && count > 20000000L && (choice = JOptionPane.showOptionDialog(this.parent_, message = (mega = count / 1000L / 1000L) > 100L ? "The variable includes " + mega + " million elements. Exporting as labeled\ntext could take a very long time and result in a multi-gigabyte file.\nShall I continue?" : "The variable includes " + mega + " million elements. Exporting as\nlabeled text could take some time and result in a very large\nfile. Shall I continue?", "Confirm", 0, 3, null, options = new String[]{"Okay", "Cancel"}, options[0])) != 0) {
            return;
        }
        String fnameRoot = ncvar.getName();
        File file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export data as\u2026", TXT_EXT, fnameRoot, TXT_EXT);
        if (file == null) {
            return;
        }
        PanExportTextTask task = new PanExportTextTask(this.parent_, ncvar, file);
        this.parent_.addTask(task);
    }
}

