/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.cl.PCLWriter;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportCLScriptAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-cl-script");
    private final PanPlotFrame parent_;
    private String fnameRoot_;
    private File outputFile_;

    public PanExportCLScriptAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    public File getFile() {
        return this.outputFile_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block4: {
            if (this.fnameRoot_ == null) {
                this.fnameRoot_ = this.parent_.getTitle();
            }
            this.fnameRoot_ = this.fnameRoot_.replaceAll("\\s", "_");
            File file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export script as\u2026", "pcl", this.fnameRoot_, "pcl");
            if (file == null) {
                return;
            }
            this.fnameRoot_ = FileUtils.extractFnameRoot(file);
            this.outputFile_ = file;
            try {
                PanPlotMeta pmeta = this.parent_.getMeta();
                PCLWriter ww = new PCLWriter(pmeta);
                ww.exportCLJavaScript(this.outputFile_, false);
            }
            catch (Exception exc) {
                GuiUtils.showSlowMessage((Component)this.parent_, "File Error", "Unable to write PCL script.");
                LOGGER.error(exc.toString());
                if (!LOGGER.isTraceEnabled()) break block4;
                exc.printStackTrace();
            }
        }
        this.parent_.toFront();
    }
}

