/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.plotui.PanArrayControls;
import gov.nasa.giss.panoply.plotui.PanControlsTabbedPane;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanCombinationType;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanChangeCombinationAction
extends AbstractAction {
    private final PanPlotFrame parent_;
    private final PanCombinationType ctype_;

    public PanChangeCombinationAction(PanPlotFrame f, PanCombinationType ctype) {
        super(ctype.getDescription());
        this.parent_ = f;
        this.ctype_ = ctype;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanData data = this.parent_.getData();
        if (data == null || data.getArray(0) == null || data.getArray(1) == null) {
            return;
        }
        PanControlsTabbedPane ctpane = this.parent_.getControlsTabbedPane();
        if (ctpane == null) {
            return;
        }
        PanArrayControls acp = (PanArrayControls)ctpane.getComponent("array-controls");
        if (acp == null) {
            return;
        }
        acp.setCombinationType(this.ctype_);
    }
}

