/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBackgroundAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean busy_;
    private PanPlotMeta pmeta_;

    public PanBackgroundAction(PanPlotMeta pmeta) {
        super("background");
        this.pmeta_ = pmeta;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanPlotFrame pframe = this.pmeta_.getFrame();
        if (pframe == null) {
            return;
        }
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        Object source = e == null ? null : e.getSource();
        Color newval = null;
        if (source instanceof JMenuItem) {
            String ctext = ((JMenuItem)source).getText().toLowerCase();
            newval = ctext.startsWith("black") ? Color.BLACK : Color.WHITE;
        } else if (source instanceof PanColorComboBox) {
            PanColorComboBox combo = (PanColorComboBox)source;
            newval = combo.getSelectedColor();
        } else if (source == null) {
            LOGGER.trace("Null source.");
            newval = this.pmeta_.getColor("color.background");
        } else {
            LOGGER.trace("Unexpected source: {}", (Object)source.getClass());
        }
        PanMenuBar mbar = pframe.getPanMenuBar();
        String mitext = newval.equals(Color.BLACK) ? "White Background" : "Black Background";
        mbar.getItemByName("plot-menu", "background").setText(mitext);
        Color cold = this.pmeta_.getColor("color.background");
        if (!newval.equals(cold)) {
            this.pmeta_.setColor("color.background", newval);
        }
        this.busy_ = false;
    }
}

