/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.panoply.PanoplyCL;
import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.desktop.PanDesktopAdapter;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.macos.PanMacApplication;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefs.PanPrefsSaver;
import gov.nasa.giss.panoply.prefs.PanSavedSettingsList;
import gov.nasa.giss.panoply.server.PanClient;
import gov.nasa.giss.panoply.server.PanServer;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanDevoMode;
import gov.nasa.giss.panoply.util.PanLoggingUtils;
import gov.nasa.giss.panoply.util.PanNcUtils;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanQuitWatcher;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.panoply.util.PanVersionChecker;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.EventQueue;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class Panoply {
    private static final Marker FATAL = MarkerFactory.getMarker("FATAL");
    private static long SPLASH_MILLIS = 4001L;
    private static long CLOSE_MILLIS = 5001L;
    private static long AUTOSAVE_MILLIS = 180001L;
    private static boolean allowMulti_;
    private static boolean starting_;
    private static boolean filesRequested_;
    private static ArrayList<File> dataFiles_;
    private static String script_;

    public static void main(String ... args) {
        starting_ = true;
        PanLoggingUtils.initLogging();
        Panoply.parseCommandLineOptions(args);
        if (script_ != null) {
            Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
            logger.info("Script option detected. Diverting to PanoplyCL.");
            new PanoplyCL(args);
            System.exit(0);
        }
        new Panoply();
    }

    private Panoply() {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String version = PanProperties.VERSION_PROPS.getString("version");
        String buildID = PanProperties.VERSION_PROPS.getString("build-id");
        logger.info("Panoply {} ({})", (Object)version, (Object)buildID);
        logger.info("{} {}", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.version"));
        logger.info("Java {}", (Object)System.getProperty("java.version"));
        boolean isMacOS = PlatformUtils.isMacintosh();
        if (!allowMulti_ && Panoply.instanceAlreadyExists()) {
            logger.info("Panoply already running on this system. Exiting.");
            System.exit(0);
        }
        PanPreferences prefs = PanPreferences.getSharedInstance();
        prefs.read();
        if (PanDevoMode.isVersion5()) {
            PanSavedSettingsList.getSharedInstance();
        }
        PanUtils.initMiscProperties();
        String lnfName = null;
        if (PlatformUtils.isLinuxEtc()) {
            if (PanDevoMode.isVersion5()) {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    lnfName = info.getClassName();
                    break;
                }
            }
        } else {
            lnfName = UIManager.getSystemLookAndFeelClassName();
        }
        if (lnfName != null) {
            try {
                UIManager.setLookAndFeel(lnfName);
            }
            catch (Exception exc) {
                logger.warn("Unable to install L&F {} - {}", (Object)lnfName, (Object)exc.toString());
            }
        }
        Hashtable<PanNcUtils.Key, Object> initHash = new Hashtable<PanNcUtils.Key, Object>();
        initHash.put(PanNcUtils.Key.DEVO_MODE, PanDevoMode.isDevo());
        initHash.put(PanNcUtils.Key.SERVER_MODE, false);
        PanNcUtils.initNetcdf(initHash);
        if (isMacOS) {
            EventQueue.invokeLater(() -> {
                block2: {
                    try {
                        PanMacApplication.init();
                    }
                    catch (Exception exc) {
                        logger.error("Failed to init PanMacApplication.");
                        if (!logger.isTraceEnabled()) break block2;
                        exc.printStackTrace();
                    }
                }
            });
        }
        PanDesktopAdapter.init();
        long splashStop = -1L;
        if (!filesRequested_) {
            try {
                Thread.sleep(101L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            splashStop = System.currentTimeMillis() + SPLASH_MILLIS;
            EventQueue.invokeLater(() -> {
                if (!filesRequested_) {
                    PanAboutFrame.getSharedInstance().reveal();
                }
            });
        } else {
            for (File f : dataFiles_) {
                try {
                    if (f == null) continue;
                    PanFileUtils.openDataset(f);
                }
                catch (Exception exc) {
                    logger.warn("Skipping file {} due to {}", (Object)f.getName(), (Object)exc.toString());
                }
            }
            dataFiles_.clear();
        }
        if (splashStop > 0L) {
            while (System.currentTimeMillis() < splashStop) {
                try {
                    Thread.sleep(101L);
                }
                catch (Exception exception) {}
            }
            EventQueue.invokeLater(() -> {
                PanAboutFrame paf = PanAboutFrame.getSharedInstance();
                paf.setVisible(false);
                paf.setLaunched(true);
            });
        }
        EventQueue.invokeLater(() -> PanSourcesFrame.getSharedInstance());
        EventQueue.invokeLater(() -> {
            File[] ff;
            if (!filesRequested_ && prefs.getBoolean("files:launch.dialog") && (ff = PanFileUtils.showOpenDataFileChooser(null)) != null) {
                PanFileUtils.openLocalFiles(null, ff);
            }
        });
        EventQueue.invokeLater(() -> PanSourcesFrame.getSharedInstance().reveal());
        if (!isMacOS) {
            EventQueue.invokeLater(() -> new Timer().schedule((TimerTask)new PanQuitWatcher(), 4L * CLOSE_MILLIS, CLOSE_MILLIS));
        }
        new Timer().schedule((TimerTask)new PanPrefsSaver(), AUTOSAVE_MILLIS, AUTOSAVE_MILLIS);
        if (prefs.getBoolean("app:version.enabled")) {
            EventQueue.invokeLater(() -> {
                PanVersionChecker vc = PanVersionChecker.getSharedInstance();
                if (vc.isTimeForCheck()) {
                    vc.checkForUpdate(false, true);
                }
            });
        }
        starting_ = false;
    }

    private static void parseCommandLineOptions(String ... args) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.trace("");
        boolean optionsAllowed = true;
        String dataPath = null;
        ArrayList<String> dataFnames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (optionsAllowed && args[i].charAt(0) == '-') {
                String optkey;
                if ("--".equals(args[i])) {
                    optionsAllowed = false;
                    continue;
                }
                switch (optkey = args[i].substring(1)) {
                    case "script": {
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for script name.");
                            System.exit(1);
                        } else {
                            script_ = args[i];
                        }
                        logger.info("Script command and filename detected.");
                        logger.info("Subsequent CL options will be ignored.");
                        return;
                    }
                    case "log": {
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for log level.");
                            System.exit(1);
                            break;
                        }
                        PanLoggingUtils.setLogLevel(args[i]);
                        break;
                    }
                    case "multi": {
                        allowMulti_ = true;
                        break;
                    }
                    case "path": {
                        if (dataPath != null) {
                            logger.warn("Path option specified > once; last choice wins.");
                        }
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for path option.");
                            System.exit(1);
                            break;
                        }
                        dataPath = args[i];
                        break;
                    }
                    case "NSDocumentRevisionsDebugMode": {
                        logger.trace("Encountered macOS -NSDocumentRevisionsDebugMode; ignoring it.");
                        ++i;
                        break;
                    }
                    default: {
                        if (optkey.startsWith("psn_")) {
                            logger.trace("Encountered macOS -psn -- ignoring it.");
                            break;
                        }
                        logger.warn("Encountered unknown option '{}' -- ignoring it", (Object)args[i]);
                        break;
                    }
                }
                continue;
            }
            dataFnames.add(args[i]);
        }
        if (dataFnames.size() > 0) {
            File dataPathdir = null;
            try {
                if (dataPath != null) {
                    dataPathdir = new File(dataPath);
                }
            }
            catch (Exception exc) {
                logger.error(FATAL, "Bad data path specification '{}'", (Object)dataPath);
                System.exit(2);
            }
            for (String fname : dataFnames) {
                if (!NcFilenameFilter.accept(fname)) {
                    logger.warn("Skipping '{}'. No recognized dataset filename extension.", (Object)fname);
                    continue;
                }
                try {
                    File f = new File(dataPathdir, fname);
                    if (f.exists()) {
                        dataFiles_.add(new File(dataPathdir, fname));
                    } else {
                        logger.warn("Skipping '{}'. File does not exist.", (Object)fname);
                    }
                }
                catch (Exception exc) {
                    logger.warn("Skipping '{}' due to {} ", (Object)fname, (Object)exc.toString());
                    continue;
                }
                filesRequested_ = dataFiles_.size() > 0;
            }
        }
    }

    public static boolean isStarting() {
        return starting_;
    }

    public static void setFilesRequested() {
        filesRequested_ = true;
    }

    private static boolean instanceAlreadyExists() {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        try {
            PanClient pc = new PanClient();
            if (dataFiles_ != null && dataFiles_.size() > 0) {
                pc.attachFiles(dataFiles_);
            }
            pc.testForServer();
            if (pc.isSuccessful()) {
                logger.info("A previous instance of Panoply is active on this computer.");
                logger.info("This instance will exit.");
                return true;
            }
            if (pc.isServerFound()) {
                logger.info("A previous instance of Panoply is active, but I couldn't talk to it.");
                logger.info("I will proceed as if there is no such instance.");
            } else {
                logger.trace("No previous instance of Panoply is running.");
            }
        }
        catch (ConnectException exc) {
            logger.info("ConnectException occurred testing whether a previous instance of Panoply is running.");
            logger.info("This likely means that there is not such an instance.");
            logger.info("I will proceed as if there is not.");
        }
        catch (Exception exc) {
            logger.info("An Exception occurred testing whether a previous instance of Panoply is running.");
            logger.info("{}", (Object)exc.toString());
            logger.info("I will proceed as if there is not.");
        }
        try {
            PanServer.getSharedInstance().start();
        }
        catch (Exception exc) {
            logger.error("Could not init PanServer: {}", (Object)exc.toString());
        }
        return false;
    }

    static {
        dataFiles_ = new ArrayList();
    }
}

