/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

public class ComplexNumber {
    public static final ComplexNumber NAN = new ComplexNumber(Double.NaN, Double.NaN);
    private double real_;
    private double imag_;
    private boolean isNaN_;

    public ComplexNumber() {
    }

    public ComplexNumber(double real, double imaginary) {
        this.real_ = real;
        this.imag_ = imaginary;
        this.isNaN_ = Double.isNaN(real) || Double.isNaN(imaginary);
    }

    public double getReal() {
        return this.real_;
    }

    public double getImaginary() {
        return this.imag_;
    }

    public boolean isNaN() {
        return this.isNaN_;
    }

    public ComplexNumber getConjugate() {
        if (this.isNaN_) {
            return NAN;
        }
        return new ComplexNumber(this.real_, -this.imag_);
    }

    public ComplexNumber add(ComplexNumber cpx) {
        if (this.isNaN_ || cpx.isNaN()) {
            return NAN;
        }
        double c = cpx.getReal();
        double d = cpx.getImaginary();
        return new ComplexNumber(this.real_ + c, this.imag_ + d);
    }

    public ComplexNumber add(double rval) {
        if (this.isNaN_) {
            return NAN;
        }
        return new ComplexNumber(this.real_ + rval, this.imag_);
    }

    public ComplexNumber subtract(ComplexNumber cpx) {
        if (this.isNaN_ || cpx.isNaN()) {
            return NAN;
        }
        double c = cpx.getReal();
        double d = cpx.getImaginary();
        return new ComplexNumber(this.real_ - c, this.imag_ - d);
    }

    public ComplexNumber subtract(double rval) {
        if (this.isNaN_) {
            return NAN;
        }
        return new ComplexNumber(this.real_ - rval, this.imag_);
    }

    public ComplexNumber multiplyBy(ComplexNumber cpx) {
        if (this.isNaN_ || cpx.isNaN()) {
            return NAN;
        }
        double rval = cpx.getReal();
        double ival = cpx.getImaginary();
        return this.multiplyBy(rval, ival);
    }

    public ComplexNumber multiplyBy(double rval) {
        if (this.isNaN_ || Double.isNaN(rval)) {
            return NAN;
        }
        return new ComplexNumber(this.real_ * rval, this.imag_ * rval);
    }

    public ComplexNumber multiplyBy(double rval, double ival) {
        if (this.isNaN_ || Double.isNaN(rval) || Double.isNaN(ival)) {
            return NAN;
        }
        return new ComplexNumber(this.real_ * rval - this.imag_ * ival, this.real_ * ival + this.imag_ * rval);
    }

    public ComplexNumber divideBy(ComplexNumber cpx) {
        if (this.isNaN_ || cpx.isNaN()) {
            return NAN;
        }
        double c = cpx.getReal();
        double d = cpx.getImaginary();
        if (c == 0.0 && d == 0.0) {
            return NAN;
        }
        double divisor = c * c + d * d;
        return new ComplexNumber((this.real_ * c + this.imag_ * d) / divisor, (this.imag_ * c - this.real_ * d) / divisor);
    }

    public ComplexNumber toPower(int power) {
        if (this.isNaN_) {
            return NAN;
        }
        if (power < 1) {
            throw new RuntimeException("Powers less than 1 not implemented.");
        }
        if (power == 1) {
            return new ComplexNumber(this.real_, this.imag_);
        }
        ComplexNumber result = this.squared();
        if (power == 2) {
            return result;
        }
        for (int i = 3; i <= power; ++i) {
            result = result.multiplyBy(this.real_, this.imag_);
        }
        return result;
    }

    public ComplexNumber squared() {
        if (this.isNaN_) {
            return NAN;
        }
        return new ComplexNumber(this.real_ * this.real_ - this.imag_ * this.imag_, 2.0 * this.real_ * this.imag_);
    }

    public String toString() {
        return "(" + this.real_ + "," + this.imag_ + "i)";
    }
}

