/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

import java.awt.geom.Point2D;

public final class Circles {
    public static Point2D.Double[] getIntersectionPoints(double x0, double y0, double r0, double x1, double y1, double r1) {
        if (x0 == x1 && y0 == y1 && r0 == r1) {
            return new Point2D.Double[0];
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        double dSq = dx * dx + dy * dy;
        double dd = Math.sqrt(dSq);
        if (dd > r0 + r1) {
            return new Point2D.Double[0];
        }
        if (dd < Math.abs(r1 - r0)) {
            return new Point2D.Double[0];
        }
        double r0Sq = r0 * r0;
        double aa = (r0Sq - r1 * r1 + dSq) / (2.0 * dd);
        double hSq = r0Sq - aa * aa;
        double hh = Math.sqrt(hSq);
        double aOverD = aa / dd;
        double hOverD = hh / dd;
        double x2 = x0 + (x1 - x0) * aOverD;
        double y2 = y0 + (y1 - y0) * aOverD;
        double x3a = x2 + (y1 - y0) * hOverD;
        double x3b = x2 - (y1 - y0) * hOverD;
        double y3a = y2 - (x1 - x0) * hOverD;
        double y3b = y2 + (x1 - x0) * hOverD;
        Point2D.Double p3a = new Point2D.Double(x3a, y3a);
        Point2D.Double p3b = new Point2D.Double(x3b, y3b);
        return new Point2D.Double[]{p3a, p3b};
    }

    private Circles() {
    }
}

