/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Wagner2
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Wagner II";
    private static final double CSUBX = 0.92483;
    private static final double CSUBY = 1.38725;
    private static final double CSUBP = 0.88022;
    private static final double INV_CSUBX = 1.081279802774564;
    private static final double INV_CSUBY = 0.7208506037123805;
    private static final double INV_CSUBP = 1.1360796164595215;
    private static final double CONST_D = 0.8855;
    private static final double INV_D = 1.129305477131564;
    private static final double MAX_X_OVER_RS = 2.9054391338194483;
    private static final double MAX_Y_OVER_RS = 1.38725 * Math.asin(0.88022 * Math.sin(1.3909401473768808));
    private double invCxRS_ = 1.0;
    private double invCyRS_ = 1.0;

    public Wagner2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.9054391338194483, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.invCxRS_ = 1.081279802774564 * this.invRS_;
        this.invCyRS_ = 0.7208506037123805 * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double thetaRad = Math.asin(0.88022 * Math.sin(0.8855 * phiRad));
        double x = 0.92483 * this.lonToLambdaRad(lon) * Math.cos(thetaRad);
        double y = 1.38725 * thetaRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double thetaRad = y * this.invCyRS_;
        double phiRad = Math.asin(Math.sin(thetaRad) * 1.1360796164595215) * 1.129305477131564;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invCxRS_ / Math.cos(thetaRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner2 wagner2 = this;
        synchronized (wagner2) {
            double y;
            double thetaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(Math.sin(thetaRad = (y = (double)iy + 0.5) * this.invCyRS_) * 1.1360796164595215) * 1.129305477131564) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invCxRS_ / Math.cos(thetaRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

