/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Wagner1
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Wagner I";
    private static final double FOURTH_ROOT_OF_3 = Math.sqrt(1.7320508075688772);
    private static final double CSUBX = 2.0 * FOURTH_ROOT_OF_3 / 3.0;
    private static final double CSUBY = FOURTH_ROOT_OF_3;
    private static final double CSUBP = 0.8660254037844386;
    private static final double INV_CSUBX = 1.0 / CSUBX;
    private static final double INV_CSUBY = 1.0 / CSUBY;
    private static final double INV_CSUBP = 1.1547005383792517;
    private static final double MAX_X_OVER_RS = CSUBX * Math.PI;
    private static final double MAX_Y_OVER_RS = CSUBY * Math.asin(0.8660254037844386);
    private double invCxRS_ = 1.0;
    private double invCyRS_ = 1.0;

    public Wagner1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.invCxRS_ = INV_CSUBX * this.invRS_;
        this.invCyRS_ = INV_CSUBY * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double thetaRad = Math.asin(0.8660254037844386 * Math.sin(Math.toRadians(lat)));
        double x = CSUBX * this.lonToLambdaRad(lon) * Math.cos(thetaRad);
        double y = CSUBY * thetaRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double thetaRad = y * this.invCyRS_;
        double phiRad = Math.asin(Math.sin(thetaRad) * 1.1547005383792517);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invCxRS_ / Math.cos(thetaRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner1 wagner1 = this;
        synchronized (wagner1) {
            double y;
            double thetaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(Math.sin(thetaRad = (y = (double)iy + 0.5) * this.invCyRS_) * 1.1547005383792517)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invCxRS_ / Math.cos(thetaRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

