/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ui.ProjDoubleComponent;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticalPerspective
extends AzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Vertical Perspective";
    private static final double DEFAULT_P = 6.61;
    private double pDist_;
    private double invP_;
    private double pMinus1_;
    private double maxClipAngle_;
    private double maxClipAngleRad_;
    private double rhoBOverRS_;
    private final ProjDoubleParameter pDistParam_ = new ProjDoubleParameter("Distance between observer and center of body", "Center Distance", "Radii (D>1)", 6.61, 1.0, Double.POSITIVE_INFINITY, false, true);

    public VerticalPerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public VerticalPerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.pDistParam_);
        this.setObserverDistance(6.61);
        this.addClipAngleParameter(this.maxClipAngle_, this.maxClipAngle_, true);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.pDistParam_) {
            this.setObserverDistance(this.pDistParam_.getValue());
        }
    }

    private void setObserverDistance(double pDist) {
        if (pDist <= 1.0) {
            throw new IllegalArgumentException("Distance P must be greater than 1.");
        }
        this.pDist_ = pDist;
        this.pMinus1_ = this.pDist_ - 1.0;
        this.invP_ = 1.0 / this.pDist_;
        this.maxClipAngleRad_ = Math.acos(this.invP_);
        this.maxClipAngle_ = Math.toDegrees(this.maxClipAngleRad_);
        if (this.edgeParam_ != null) {
            LOGGER.trace("Updating clipAngleParam");
            this.edgeParam_.setMaximum(this.maxClipAngle_);
            if (this.edgeAngle_ > this.maxClipAngle_) {
                this.edgeParam_.setValue(this.maxClipAngle_);
            }
        }
        this.updateParamComponents();
        this.autoscale();
    }

    @Override
    public final void setEdgeAngle(double angle) {
        if (angle > 90.0) {
            throw new IllegalArgumentException("Clip angle must be <= 90 degrees.");
        }
        if (angle <= 0.0) {
            throw new IllegalArgumentException("Clip angle must be > 0.");
        }
        this.edgeAngle_ = angle;
        this.edgeAngleRad_ = Math.toRadians(this.edgeAngle_);
        double cosZ = Math.cos(this.edgeAngleRad_);
        if (cosZ < this.invP_) {
            LOGGER.trace("Angle {} > max {}. Resetting.", (Object)this.edgeAngle_, (Object)this.maxClipAngle_);
            this.edgeAngle_ = this.maxClipAngle_;
            this.edgeAngleRad_ = this.maxClipAngleRad_;
            this.updateParamComponents();
        }
        this.autoscale();
    }

    @Override
    public final void setAzimuthalFill(boolean fill) {
        LOGGER.debug("Fill param is not used by this projection");
    }

    @Override
    protected final void prepareScaling() {
        this.rhoBOverRS_ = this.pMinus1_ * Math.sin(this.maxClipAngleRad_) / (this.pDist_ - this.invP_);
        double pscaling = 1.0;
        if (this.edgeAngle_ < this.maxClipAngle_) {
            double cosZ = Math.cos(this.edgeAngleRad_);
            double sinZ = Math.sin(this.edgeAngleRad_);
            double rhoM = this.pMinus1_ * sinZ / (this.pDist_ - cosZ);
            pscaling = rhoM / this.rhoBOverRS_;
        }
        this.setMaxXYOverRS(pscaling * this.rhoBOverRS_);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.rhoBOverRS_ * this.rS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < this.invP_) {
            return -1.0;
        }
        return this.pMinus1_ / (this.pDist_ - cosZ);
    }

    @Override
    protected double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double sqrtM = rhoOverRS / this.pMinus1_;
        double m = sqrtM * sqrtM;
        double mPlus1 = m + 1.0;
        double mP = m * this.pDist_;
        double sqrtTerm = mPlus1 - mP * this.pDist_;
        double cosZ = sqrtTerm > 0.0 ? (mP + Math.sqrt(sqrtTerm)) / mPlus1 : mP / mPlus1;
        return Math.acos(cosZ);
    }

    @Override
    protected final void updateParamComponents() {
        if (PlatformUtils.isHeadless()) {
            return;
        }
        if (this.edgeParam_ != null) {
            EventQueue.invokeLater(() -> {
                if (this.edgeParam_ == null) {
                    return;
                }
                ProjParamComponent ppc = this.getParamComponent(this.edgeParam_);
                if (ppc == null) {
                    LOGGER.trace("Max angle component is null.");
                    return;
                }
                LOGGER.trace("Updating max angle component.");
                String unitsStr = this.getEdgeAngleUnitsStr(this.maxClipAngle_, true);
                ((ProjDoubleComponent)ppc).setUnitsStr(unitsStr);
                ((ProjDoubleComponent)ppc).setValue(this.edgeAngle_);
            });
        }
    }
}

