/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiltedPerspective
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Tilted Perspective";
    public static final int PROPERTIES = 0xA00040;
    private static final double DEFAULT_P = 2.0;
    private double pDist_;
    private double invP_;
    private double pMinus1_;
    private double pPlus1_;
    private double rhoEdgeOverR_;
    private double cosGamma_;
    private double sinGamma_;
    private double cosOmega_;
    private double sinOmega_;
    private final ProjDoubleParameter pDistParam_;
    private final ProjDoubleParameter azimParam_;
    private final ProjDoubleParameter tiltParam_;
    private double cosPhiC_;
    private double sinPhiC_;

    public TiltedPerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public TiltedPerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0xA00040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.setCenter(this.lambdaC_, this.phiC_);
        this.pDistParam_ = new ProjDoubleParameter("Distance between observer and center of body", "Center Distance", "Radii (P>1)", 2.0, 1.0, Double.POSITIVE_INFINITY, false, true);
        this.azimParam_ = new ProjDoubleParameter("Azimuth angle", "Azimuth angle", "\u00b0", 0.0, -360.0, 360.0, true, true);
        this.tiltParam_ = new ProjDoubleParameter("Tilt-up angle", "Tilt-up angle", "\u00b0", 0.0, -90.0, 90.0, true, false);
        this.addParameter(this.pDistParam_);
        this.addParameter(this.azimParam_);
        this.addParameter(this.tiltParam_);
        this.setZoomEnabled(true);
        this.setZoom(4.0);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setObserverDistance(this.pDistParam_.getValue());
            this.setAzimuthAngle(this.azimParam_.getValue());
            this.setTiltAngle(this.tiltParam_.getValue());
        } else if (p == this.pDistParam_) {
            this.setObserverDistance(this.pDistParam_.getValue());
        } else if (p == this.azimParam_) {
            this.setAzimuthAngle(this.azimParam_.getValue());
        } else if (p == this.getParameter(2)) {
            this.setTiltAngle(this.tiltParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setObserverDistance(double pDist) {
        if (pDist <= 1.0) {
            throw new IllegalArgumentException("Distance P must be greater than 1.");
        }
        this.pDist_ = pDist;
        this.pMinus1_ = this.pDist_ - 1.0;
        this.pPlus1_ = this.pDist_ + 1.0;
        this.invP_ = 1.0 / this.pDist_;
        this.autoscale();
    }

    private void setTiltAngle(double angle) {
        double omegaRad = Math.toRadians(angle);
        this.cosOmega_ = Math.cos(omegaRad);
        this.sinOmega_ = Math.sin(omegaRad);
        this.autoscale();
    }

    private void setAzimuthAngle(double gamma) {
        double gammaRad = Math.toRadians(gamma);
        this.cosGamma_ = Math.cos(gammaRad);
        this.sinGamma_ = Math.sin(gammaRad);
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.rhoEdgeOverR_ = Math.sqrt(this.pMinus1_ / this.pPlus1_);
        this.setMaxXYOverRS(this.rhoEdgeOverR_);
    }

    @Override
    protected final void finishScaling() {
    }

    private double getKForCosZ(double cosZ) {
        if (cosZ < this.invP_) {
            return -1.0;
        }
        return this.pMinus1_ / (this.pDist_ - cosZ);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double sinLambda = Math.sin(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        double k = this.getKForCosZ(cosZ);
        if (k < 0.0) {
            return null;
        }
        double x = k * cosPhi * sinLambda;
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        double xpp = x * this.cosGamma_ - y * this.sinGamma_;
        double ypp = y * this.cosGamma_ + x * this.sinGamma_;
        double a = ypp * this.sinOmega_ / this.pMinus1_ + this.cosOmega_;
        double xt = xpp * this.cosOmega_ / a;
        double yt = ypp / a;
        xt *= this.rS_;
        yt *= this.rS_;
        xt = (double)this.outCenterX_ + xt;
        yt = (double)this.outCenterY_ - yt;
        return new Point2D.Double(xt, yt);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double hh = this.pMinus1_;
        double xxx = xx - (double)this.outCenterX_;
        double xt = xxx * this.invRS_;
        double yyy = (double)this.outCenterY_ - yy;
        double yt = yyy * this.invRS_;
        double hMinusYtSinOmega = hh - yt * this.sinOmega_;
        double xpp = hh * xt / hMinusYtSinOmega;
        double ypp = hh * yt * this.cosOmega_ / hMinusYtSinOmega;
        double x = xpp * this.cosGamma_ + ypp * this.sinGamma_;
        double y = ypp * this.cosGamma_ - xpp * this.sinGamma_;
        double rho2 = x * x + y * y;
        double rho = Math.sqrt(rho2);
        if (rho > this.rhoEdgeOverR_) {
            return null;
        }
        double z = this.getZRadForRhoOverRS(rho);
        double[] lambdaPhi = this.getLambdaPhiForXYRhoZ(x, y, rho, z);
        if (lambdaPhi == null) {
            return null;
        }
        double lambda = lambdaPhi[0];
        double phi = lambdaPhi[1];
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        TiltedPerspective tiltedPerspective = this;
        synchronized (tiltedPerspective) {
            if (this.pMinus1_ <= 0.0) {
                return;
            }
            double hh = this.pMinus1_;
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double yyy = (double)iy + 0.5;
                double yt = yyy * this.invRS_;
                double hMinusYtSinOmega = hh - yt * this.sinOmega_;
                double ypp = this.pMinus1_ * yt * this.cosOmega_ / hMinusYtSinOmega;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double z;
                    double[] lambdaPhi;
                    double xxx = (double)ix + 0.5;
                    double xt = xxx * this.invRS_;
                    double xpp = this.pMinus1_ * xt / hMinusYtSinOmega;
                    double x = xpp * this.cosGamma_ + ypp * this.sinGamma_;
                    double y = ypp * this.cosGamma_ - xpp * this.sinGamma_;
                    double rho2 = x * x + y * y;
                    double rho = Math.sqrt(rho2);
                    if (rho > this.rhoEdgeOverR_ || (lambdaPhi = this.getLambdaPhiForXYRhoZ(x, y, rho, z = this.getZRadForRhoOverRS(rho))) == null) continue;
                    double lambda = lambdaPhi[0];
                    double phi = lambdaPhi[1];
                    this.setInvPoint(ix, iy, this.lambdaC_ + lambda, phi);
                }
            }
        }
    }

    protected double getZRadForRhoOverRS(double rho) {
        double sqrtM = rho / this.pMinus1_;
        double m = sqrtM * sqrtM;
        double mPlus1 = m + 1.0;
        double mP = m * this.pDist_;
        double sqrtTerm = mPlus1 - mP * this.pDist_;
        double cosZ = sqrtTerm > 0.0 ? (mP + Math.sqrt(sqrtTerm)) / mPlus1 : mP / mPlus1;
        return Math.acos(cosZ);
    }

    private double[] getLambdaPhiForXYRhoZ(double x, double y, double rho, double z) {
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new double[]{lambda, phi};
    }

    private void setInvPoint(int ix, int iy, double lon, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
    }
}

