/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class StabiusWerner1
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Stabius-Werner I";
    public static final int PROPERTIES = 0x2000200;
    private static final double MAX_X_OVER_RS = 1.0;
    private static final double MAX_Y_OVER_RS = 1.0;
    private static final double SW_SCALING = 1.5707963267948966;
    private double phi1_ = 90.0;
    private double phi1Rad_;
    private double cotPhi1_;
    private double yshift_;
    private double lobeTipLat_;
    private int leftCenterX_;
    private int rightCenterX_;

    public StabiusWerner1(int width, int height) {
        this(width, height, 0, 0);
    }

    public StabiusWerner1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2000200, width, height, xmargin, ymargin, 1.0, 1.0);
        this.setStandardParallel(90.0);
        this.finishConstruction();
    }

    private void setStandardParallel(double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Lat must be in range [-90\u0080,90\u0080].");
        }
        this.phi1_ = lat;
        if (this.phi1_ == 0.0) {
            this.phi1_ = 1.0E-6;
        }
        this.phi1Rad_ = Math.toRadians(this.phi1_);
        this.cotPhi1_ = 1.0 / Math.tan(this.phi1Rad_);
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double yy;
        double latX = this.latitudeOfMaxX();
        double phiRad = Math.toRadians(latX);
        double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
        double betaRad = 2.4674011002723395 * Math.cos(phiRad) / alphaRad;
        double widthFactor = alphaRad * Math.sin(betaRad);
        double phiRad2 = this.phi1_ > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        double alphaRad2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
        double y1 = this.cotPhi1_ - alphaRad2;
        phiRad2 = this.phi1_ > 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        alphaRad2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
        double y2 = this.cotPhi1_ - alphaRad2;
        if (Math.abs(this.phi1_) > 11.5232593818) {
            this.lobeTipLat_ = this.latitudeOfLobeMaxY();
            if (Double.isNaN(this.lobeTipLat_)) {
                this.lobeTipLat_ = 0.0;
                yy = y1;
            } else {
                phiRad2 = Math.toRadians(this.lobeTipLat_);
                alphaRad2 = this.cotPhi1_ + this.phi1Rad_ - phiRad2;
                double betaRad2 = 2.4674011002723395 * Math.cos(phiRad2) / alphaRad2;
                yy = this.cotPhi1_ - alphaRad2 * Math.cos(betaRad2);
            }
        } else {
            this.lobeTipLat_ = 0.0;
            yy = y1;
        }
        if (Math.abs(y1) > Math.abs(yy)) {
            yy = y1;
        }
        this.yshift_ = -0.5 * (yy + y2);
        double heightFactor = 0.5 * Math.abs(yy - y2);
        this.setMaxXYOverRS(2.1 * widthFactor, heightFactor);
    }

    @Override
    protected final void finishScaling() {
        Insets ins = this.getInsets();
        this.leftCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + ins.left));
        this.rightCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + this.getWidth() - ins.right));
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double altXY;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        if (rightside) {
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        if ((altXY = this.transformAltLL2XYIgnoreMargins(altLon, lat)) == null) {
            return null;
        }
        double x = rightside ? altXY.x + (double)this.rightCenterX_ : altXY.x + (double)this.leftCenterX_;
        double y = altXY.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformAltLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        if (Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        if (lambdaRad == 0.0 || Math.abs(phiRad) == 1.5707963267948966) {
            double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
            x = 0.0;
            y = this.yshift_ + this.cotPhi1_ - alphaRad;
        } else {
            double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
            if (Math.abs(alphaRad) < 1.0E-5) {
                return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.yshift_ * this.rS_);
            }
            double betaRad = lambdaRad * 1.5707963267948966 * Math.cos(phiRad) / alphaRad;
            x = alphaRad * Math.sin(betaRad);
            y = this.yshift_ + this.cotPhi1_ - alphaRad * Math.cos(betaRad);
        }
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x *= this.rS_, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double yOverRS;
        double y1;
        double xOverRS;
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
        double alphaRad = pmFac * Math.hypot(xOverRS = x * this.invRS_, y1 = this.cotPhi1_ - (yOverRS = y * this.invRS_ - this.yshift_));
        double phiRad = this.cotPhi1_ + this.phi1Rad_ - alphaRad;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double betaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
        double lambdaRad = betaRad * alphaRad / Math.cos(phiRad) / 1.5707963267948966;
        if (Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        if (!leftside) {
            lambdaRad += Math.PI;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        StabiusWerner1 stabiusWerner1 = this;
        synchronized (stabiusWerner1) {
            double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - this.yshift_;
                double y1 = this.cotPhi1_ - yOverRS;
                for (int ix = 0; ix < 2 * this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double alphaRad = pmFac * Math.hypot(xOverRS, y1);
                    double phiRad = this.cotPhi1_ + this.phi1Rad_ - alphaRad;
                    if (Math.abs(phiRad) > 1.5707963267948966) continue;
                    double betaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
                    double lambdaRad = betaRad * alphaRad / Math.cos(phiRad) / 1.5707963267948966;
                    if (lambdaRad > 1.5707963267948966) {
                        if (!(Math.abs(this.phi1_) < 11.5232593818)) continue;
                        continue block3;
                    }
                    this.setFourPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private void setFourPoints(int ix, int iy, double lambdaP, double phiP) {
        this.setInvPoint(true, ix, iy, this.lambdaC_ + lambdaP, phiP);
        this.setInvPoint(true, -ix - 1, iy, this.lambdaC_ - lambdaP, phiP);
        this.setInvPoint(false, ix, iy, this.lambdaC_ + lambdaP + 180.0, phiP);
        this.setInvPoint(false, -ix - 1, iy, this.lambdaC_ - lambdaP + 180.0, phiP);
    }

    private void setInvPoint(boolean leftside, int ix, int iy, double lon, double lat) {
        int col = leftside ? this.leftCenterX_ + ix : this.rightCenterX_ + ix;
        int row = this.outCenterY_ - iy - 1;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier bcurve = this.makeBezier(this.lambdaC_ + 89.99999);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeBezier(this.lambdaC_ - 89.99999)) != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeBezier(this.lambdaC_ + 180.0 + 89.99999)) != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeBezier(this.lambdaC_ + 180.0 - 89.99999)) != null) {
            bcurve.draw(g2d);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        for (int i = 0; i < 2; ++i) {
            double lonc = i == 0 ? this.lambdaC_ : this.lambdaC_ + 180.0;
            double lon1 = lonc + -89.99999;
            double lon2 = lonc;
            double lon3 = lonc + 89.99999;
            Point2D.Double dot1 = this.transformLL2XY(lon1, lat);
            Point2D.Double dot2 = this.transformLL2XY(lon2, lat);
            Point2D.Double dot3 = this.transformLL2XY(lon3, lat);
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double dlon = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (Math.abs(dlon - 90.0) < 1.0E-5) {
            return;
        }
        Bezier bcurve = this.makeBezier(lon);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
    }

    private Bezier makeBezier(double lon) {
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(100);
        double lat = -90.0;
        while (lat <= 90.0) {
            Point2D.Double dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                if (ptlist.size() < 2) {
                    return null;
                }
                return new Bezier(false, ptlist);
            }
            ptlist.add(new Point2D.Double(dot.x, dot.y));
            double nextlat = 0.0;
            double absLat = Math.abs(lat);
            nextlat = absLat >= 89.0 ? lat + 0.1 : (absLat >= 85.0 ? lat + 0.25 : lat + 0.5);
            if (lat < 90.0 && nextlat > 89.99999) {
                nextlat = 90.0;
            }
            lat = nextlat;
        }
        if (ptlist.size() < 2) {
            return null;
        }
        return new Bezier(false, ptlist);
    }

    private double latitudeOfMaxX() {
        if (this.phi1_ == 0.0) {
            return 0.0;
        }
        double phiRad = -Math.toRadians(0.5 * this.phi1_);
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
            double betaRad = 1.5707963267948966 * cosPhi / alphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = (-2.4674011002723395 * sinPhi + betaRad) / alphaRad;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double func = -sinBeta + alphaRad * dsinBeta;
            double dfunc = alphaRad * dcosBeta * dbetaRad - cosBeta * 1.5707963267948966 * 1.5707963267948966 * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }

    private double latitudeOfLobeMaxY() {
        if (Math.abs(this.phi1_) <= 11.5232593818) {
            return Double.NaN;
        }
        double phiRad = Math.toRadians(45.0);
        if (this.phi1_ < 0.0) {
            phiRad = -phiRad;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
            double betaRad = 1.5707963267948966 * cosPhi / alphaRad;
            double sinBeta = Math.sin(betaRad);
            double cosBeta = Math.cos(betaRad);
            double dbetaRad = (-2.4674011002723395 * sinPhi + betaRad) / alphaRad;
            double dsinBeta = cosBeta * dbetaRad;
            double dcosBeta = -sinBeta * dbetaRad;
            double func = cosBeta - alphaRad * dcosBeta;
            double dfunc = alphaRad * dsinBeta * dbetaRad - sinBeta * 1.5707963267948966 * 1.5707963267948966 * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return Math.toDegrees(phiRad);
    }
}

