/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolovevPerspectiveCylindrical
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Solov'ev Perspective Cyliindrical";
    public static final int PROPERTIES = 0x200004;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private static final double DEFAULT_P = 1.0;
    private static final double DEFAULT_PHI1 = 45.0;
    private static final double DEFAULT_HEIGHT = 180.0;
    private final LonLatRotator rotMatrices_ = new LonLatRotator(this.lambdaC_, this.phiC_);
    private final ProjDoubleParameter distParam_ = new ProjDoubleParameter("Distance of perspective", "Perspect. dist.", "Radii (D\u22651)", 1.0, 0.0, Double.POSITIVE_INFINITY, true, true);
    private final ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude' of secant parallel", "Sec. Par.'", "\u00b0N", 45.0, -75.0, 75.0, true, true);
    private final ProjDoubleParameter hgtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center", "Height", "\u00b0", 180.0, 0.002, 180.0, true, true);
    private double cosPhiPTS_;
    private double pPerspective_ = 1.0;
    private double pPlusCosPhiPTS_;
    private double heightDeg_ = 180.0;

    public SolovevPerspectiveCylindrical(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200004, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.distParam_);
        this.addParameter(this.phi1Param_);
        this.addParameter(this.hgtParam_);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(lon, lat);
        }
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.distParam_ || p == this.phi1Param_ || p == this.hgtParam_) {
            this.setObserverDistance(this.distParam_.getValue());
            this.setStandardParallelP(this.phi1Param_.getValue());
            this.setHeight(this.hgtParam_.getValue());
        } else if (p == this.distParam_) {
            this.setObserverDistance(this.distParam_.getValue());
        } else if (p == this.distParam_) {
            this.setStandardParallelP(this.phi1Param_.getValue());
        } else if (p == this.hgtParam_) {
            this.setHeight(this.hgtParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setObserverDistance(double d) {
        this.pPerspective_ = d;
        this.autoscale();
    }

    private void setStandardParallelP(double latP) {
        if (Math.abs(latP) > 90.0) {
            throw new IllegalArgumentException("Lat must be in range [-90\u0080,90\u0080].");
        }
        double phiPTS = Math.abs(latP) < 1.0E-5 ? 1.0E-5 : latP;
        this.cosPhiPTS_ = Math.cos(Math.toRadians(phiPTS));
        this.autoscale();
    }

    private void setHeight(double height) {
        this.heightDeg_ = height;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double phiPRad = 0.5 * Math.toRadians(this.heightDeg_);
        double hh = this.pPlusCosPhiPTS_ * Math.sin(phiPRad) / (this.pPerspective_ + Math.cos(phiPRad));
        Insets ins = this.getInsets();
        double whRatio = ((double)this.getWidth() - 2.0 * (double)ins.left) / ((double)this.getHeight() - 2.0 * (double)ins.top);
        double ww = Math.min(Math.PI * this.cosPhiPTS_, hh * whRatio);
        this.setMaxXYOverRS(ww, hh);
    }

    @Override
    protected final void finishScaling() {
        LOGGER.trace("RS {}", (Object)this.rS_);
        this.pPlusCosPhiPTS_ = this.pPerspective_ + this.cosPhiPTS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double lambdaPRad = Math.toRadians(llP[0]);
        double phiPRad = Math.toRadians(llP[1]);
        double cosPhiP = Math.cos(phiPRad);
        double sinPhiP = Math.sin(phiPRad);
        double x = lambdaPRad * this.cosPhiPTS_;
        double y = this.pPlusCosPhiPTS_ * sinPhiP / (this.pPerspective_ + cosPhiP);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double lambdaPRad = xOverRS / this.cosPhiPTS_;
        if (lambdaPRad > Math.PI) {
            return null;
        }
        double phiPRad = 0.0;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double cosPhiP = Math.cos(phiPRad);
            double sinPhiP = Math.sin(phiPRad);
            double denom = this.pPerspective_ + cosPhiP;
            double func = this.pPlusCosPhiPTS_ * sinPhiP / denom - yOverRS;
            double dfunc = this.pPlusCosPhiPTS_ * (cosPhiP + sinPhiP * sinPhiP / denom) / denom;
            double dphiPRad = -func / dfunc;
            phiPRad += dphiPRad;
            if (!(Math.abs(dphiPRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        double phiP = Math.toDegrees(phiPRad);
        double lambdaP = Math.toDegrees(lambdaPRad);
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        SolovevPerspectiveCylindrical solovevPerspectiveCylindrical = this;
        synchronized (solovevPerspectiveCylindrical) {
            double x;
            double xOverRS;
            double lambdaPRad;
            block5: for (int ix = 0; ix < this.dxMax_ && !((lambdaPRad = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) / this.cosPhiPTS_) > Math.PI); ++ix) {
                double lambdaP = Math.toDegrees(lambdaPRad);
                for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                    double[] ll;
                    double y = (double)iy + 0.5;
                    double yOverRS = y * this.invRS_;
                    double phiPRad = 0.0;
                    boolean found = false;
                    for (int iter = 0; iter < 33; ++iter) {
                        double cosPhiP = Math.cos(phiPRad);
                        double sinPhiP = Math.sin(phiPRad);
                        double denom = this.pPerspective_ + cosPhiP;
                        double func = this.pPlusCosPhiPTS_ * sinPhiP / denom - yOverRS;
                        double dfunc = this.pPlusCosPhiPTS_ * (cosPhiP + sinPhiP * sinPhiP / denom) / denom;
                        double dphiPRad = -func / dfunc;
                        phiPRad += dphiPRad;
                        if (!(Math.abs(dphiPRad) < 1.0E-5)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue block5;
                    double phiP = Math.toDegrees(phiPRad);
                    try {
                        ll = this.rotMatrices_.inverse(lambdaP, phiP);
                    }
                    catch (Exception exc) {
                        continue block5;
                    }
                    this.setInvPoints(ix, iy, ll[0] - this.lambdaC_, ll[1]);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
    }
}

