/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class RobinsonCD
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Robinson CD";
    private static final double A0 = 0.8507;
    private static final double A1 = 0.9642;
    private static final double A2 = -0.145;
    private static final double A3 = -0.0013;
    private static final double A4 = -0.0104;
    private static final double A5 = -0.0129;
    private static final double MAX_X_OVER_RS = 2.672552870408837;
    private static final double MAX_Y_OVER_RS = 1.3861591129060238;

    public RobinsonCD(int width, int height) {
        this(width, height, 0, 0);
    }

    public RobinsonCD(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.672552870408837, 1.3861591129060238);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (phiRad == 0.0) {
            x = lambdaRad * 0.8507;
            y = 0.0;
        } else {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            y = phiRad * (0.9642 + -0.0013 * phiRad2 + -0.0129 * phiRad4);
            x = lambdaRad == 0.0 ? 0.0 : lambdaRad * (0.8507 + -0.145 * phiRad2 + -0.0104 * phiRad4);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad2;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        if (y == 0.0) {
            phiRad = 0.0;
        } else {
            phiRad = 1.5707963267948966 * y / this.ymRS_;
            boolean found = false;
            for (int iter = 0; iter < 33; ++iter) {
                phiRad2 = phiRad * phiRad;
                double a3phiRad2 = -0.0013 * phiRad2;
                double a5phiRad4 = -0.0129 * phiRad2 * phiRad2;
                double numerator = phiRad * (0.9642 + a3phiRad2 + a5phiRad4) - yOverRS;
                double denominator = 0.9642 + 3.0 * a3phiRad2 + 5.0 * a5phiRad4;
                double dphiRad = -numerator / denominator;
                phiRad += dphiRad;
                if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
            if (phiRad > 1.5707963267948966) {
                return null;
            }
        }
        if (x == 0.0) {
            lambdaRad = 0.0;
        } else if (phiRad == 0.0) {
            lambdaRad = x * this.invRS_ / 0.8507;
        } else {
            phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            lambdaRad = x * this.invRS_ / (0.8507 + -0.145 * phiRad2 + -0.0104 * phiRad4);
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double phiRad = 0.0;
        RobinsonCD robinsonCD = this;
        synchronized (robinsonCD) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                phiRad += 1.0E-5;
                boolean found = false;
                for (int iter = 0; iter < 33; ++iter) {
                    double phiRad2 = phiRad * phiRad;
                    double a3phiRad2 = -0.0013 * phiRad2;
                    double a5phiRad4 = -0.0129 * phiRad2 * phiRad2;
                    double numerator = phiRad * (0.9642 + a3phiRad2 + a5phiRad4) - yOverRS;
                    double denominator = 0.9642 + 3.0 * a3phiRad2 + 5.0 * a5phiRad4;
                    double dphiRad = -numerator / denominator;
                    phiRad += dphiRad;
                    if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                double phi = Math.toDegrees(phiRad);
                double phiRad2 = phiRad * phiRad;
                double phiRad4 = phiRad2 * phiRad2;
                double xFactor = this.invRS_ / (0.8507 + -0.145 * phiRad2 + -0.0104 * phiRad4);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    double lambda = Math.toDegrees(lambdaRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }
}

