/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Robinson
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Robinson";
    private static final double A0 = 0.8488;
    private static final double A2 = -0.1168;
    private static final double A4 = -0.04775;
    private static final double A6 = 0.01206;
    private static final double B1 = 0.96407;
    private static final double B2 = -0.00857;
    private static final double BX = 6.41;
    private static final double MAX_X_OVER_RS = 2.6665838443670165;
    private static final double MAX_Y_OVER_RS = 1.35943699216842;

    public Robinson(int width, int height) {
        this(width, height, 0, 0);
    }

    public Robinson(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.6665838443670165, 1.35943699216842);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (phiRad == 0.0) {
            x = lambdaRad * 0.8488;
            y = 0.0;
        } else {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double phiRad6 = phiRad4 * phiRad2;
            double aphiRad = lat > 0.0 ? phiRad : -phiRad;
            y = 0.96407 * aphiRad + -0.00857 * Math.pow(aphiRad, 6.41);
            if (lat < 0.0) {
                y = -y;
            }
            x = lambdaRad == 0.0 ? 0.0 : lambdaRad * (0.8488 + -0.1168 * phiRad2 + -0.04775 * phiRad4 + 0.01206 * phiRad6);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        if (Math.abs(yOverRS) > this.ymRS_) {
            return null;
        }
        if (y == 0.0) {
            phiRad = 0.0;
        } else {
            phiRad = 1.5707963267948966 * Math.abs(y) / this.ymRS_;
            boolean found = false;
            for (int iter = 0; iter < 33; ++iter) {
                double numerator = 0.96407 * phiRad + -0.00857 * Math.pow(phiRad, 6.41) - yOverRS;
                double denominator = 0.96407 + -0.054933699999999995 * Math.pow(phiRad, 5.41);
                double dphiRad = -numerator / denominator;
                phiRad += dphiRad;
                if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
            if (y < 0.0) {
                phiRad = -phiRad;
            }
            if (phiRad > 1.5707963267948966) {
                return null;
            }
        }
        if (x == 0.0) {
            lambdaRad = 0.0;
        } else if (phiRad == 0.0) {
            lambdaRad = x * this.invRS_ / 0.8488;
        } else {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double phiRad6 = phiRad4 * phiRad2;
            lambdaRad = x * this.invRS_ / (0.8488 + -0.1168 * phiRad2 + -0.04775 * phiRad4 + 0.01206 * phiRad6);
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double phiRad = 0.0;
        Robinson robinson = this;
        synchronized (robinson) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                phiRad += 1.0E-5;
                boolean found = false;
                for (int iter = 0; iter < 33; ++iter) {
                    double numerator = 0.96407 * phiRad + -0.00857 * Math.pow(phiRad, 6.41) - yOverRS;
                    double denominator = 0.96407 + -0.054933699999999995 * Math.pow(phiRad, 5.41);
                    double dphiRad = -numerator / denominator;
                    phiRad += dphiRad;
                    if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                double phi = Math.toDegrees(phiRad);
                double phiRad2 = phiRad * phiRad;
                double phiRad4 = phiRad2 * phiRad2;
                double phiRad6 = phiRad4 * phiRad2;
                double xFactor = this.invRS_ / (0.8488 + -0.1168 * phiRad2 + -0.04775 * phiRad4 + 0.01206 * phiRad6);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    double lambda = Math.toDegrees(lambdaRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }
}

