/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaiszArmadillo
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Raisz Armadillo";
    public static final int PROPERTIES = 256;
    private static final double DEFAULT_TILT = 20.0;
    private static final double MAX_TILT = 90.0;
    private static final double MAX_X_OVER_RS = 2.0;
    private static final double MAX_Y_OVER_RS = 1.2071067811865475;
    private double tilt_;
    private double cosTilt_;
    private double sinTilt_;
    private double tanTilt_;
    private double yshift_;
    private double latMin_;
    private double latMax_;
    private double ycentMin_;
    private double ycentMax_;
    private double yhornMin_;
    private double yhornMax_;
    private Bezier[] borderCurves_;
    private final ProjDoubleParameter tiltParam_ = new ProjDoubleParameter("Angle that shape is tilted downward", "Tilt Angle", "\u00b0", 20.0, -90.0, 90.0);

    public RaiszArmadillo(int width, int height) {
        this(width, height, 0, 0);
    }

    public RaiszArmadillo(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 256, width, height, xmargin, ymargin, 2.0, 1.2071067811865475);
        this.addParameter(this.tiltParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.tiltParam_) {
            this.setTiltAngle(this.tiltParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setTiltAngle(double tilt) {
        if (Math.abs(tilt) > 90.0) {
            throw new IllegalArgumentException("Specified tilt outside valid range");
        }
        this.tilt_ = tilt;
        double tiltRad = Math.toRadians(this.tilt_);
        this.cosTilt_ = Math.cos(tiltRad);
        this.sinTilt_ = Math.sin(tiltRad);
        this.tanTilt_ = Math.tan(tiltRad);
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            this.setMaxXYOverRS(2.0, this.cosTilt_);
        } else {
            double y1 = this.tilt_ > 0.0 ? this.cosTilt_ : -this.cosTilt_;
            double y2 = (this.tilt_ > 0.0 ? -1.0 : 1.0) - this.sinTilt_;
            this.setMaxXYOverRS(2.0, 0.5 * Math.abs(y1 - y2));
        }
    }

    @Override
    protected final void finishScaling() {
        this.yshift_ = Math.abs(this.tilt_) < 1.0E-5 ? 0.0 : (this.tilt_ > 0.0 ? 0.5 * (this.sinTilt_ - this.cosTilt_ + 1.0) : 0.5 * (this.sinTilt_ + this.cosTilt_ - 1.0));
        this.latMin_ = this.tilt_ > 0.0 ? -90.0 + this.tilt_ + 0.01 : -90.0;
        this.latMax_ = this.tilt_ < 0.0 ? 90.0 + this.tilt_ - 0.01 : 90.0;
        this.ycentMin_ = this.transformLL2XYIgnoreMargins((double)this.lambdaC_, (double)this.latMin_).y;
        this.ycentMax_ = this.transformLL2XYIgnoreMargins((double)this.lambdaC_, (double)this.latMax_).y;
        this.yhornMin_ = this.tilt_ > 0.0 ? this.ycentMax_ : this.transformLL2XYIgnoreMargins((double)(this.lambdaC_ + 180.0), (double)-90.0).y;
        this.yhornMax_ = this.tilt_ < 0.0 ? this.ycentMin_ : this.transformLL2XYIgnoreMargins((double)(this.lambdaC_ + 180.0), (double)90.0).y;
        this.ycentMin_ = -(this.ycentMin_ - (double)this.outCenterY_);
        this.ycentMax_ = -(this.ycentMax_ - (double)this.outCenterY_);
        this.yhornMin_ = -(this.yhornMin_ - (double)this.outCenterY_);
        this.yhornMax_ = -(this.yhornMax_ - (double)this.outCenterY_);
        this.borderCurves_ = null;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambda = this.lonToLambda(lon);
        double latLimit = this.findLatLimit(lambda);
        if (this.tilt_ > 0.0 && lat < latLimit || this.tilt_ < 0.0 && lat > latLimit) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double onePlusCosPhi = 1.0 + cosPhi;
        double halfLambdaRad = Math.toRadians(0.5 * lambda);
        double x = onePlusCosPhi * Math.sin(halfLambdaRad);
        double y = this.yshift_ + this.cosTilt_ * sinPhi - this.sinTilt_ * onePlusCosPhi * Math.cos(halfLambdaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        if (absX > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double lambdaRad0 = 1.0E-5;
        double phiRad0 = 1.0E-5;
        if (y >= this.ycentMin_ && y <= this.ycentMax_) {
            lambdaRad0 = 2.356194490192345;
            phiRad0 = (this.latMin_ + (y - this.ycentMin_) / (this.ycentMax_ - this.ycentMin_) * (this.latMax_ - this.latMin_)) * (Math.PI / 180);
        } else if (y > this.yhornMin_ && y < this.yhornMax_) {
            if (this.tilt_ > 0.0) {
                lambdaRad0 = 2.0 * Math.acos((this.yshift_ + this.cosTilt_ - y * this.invRS_) / this.sinTilt_);
                phiRad0 = Math.toRadians(89.0);
            } else if (this.tilt_ < 0.0) {
                lambdaRad0 = 2.0 * Math.acos((this.yshift_ - this.cosTilt_ - y * this.invRS_) / this.sinTilt_);
                phiRad0 = Math.toRadians(-89.0);
            } else {
                lambdaRad0 = 2.356194490192345;
                phiRad0 = 0.0;
            }
            double xMin = (int)(0.5 + this.rS_ * Math.sin(0.5 * lambdaRad0));
            if (absX < xMin) {
                return null;
            }
        } else {
            return null;
        }
        double[] llRad = this.iterateXY2LLRad(absX, y, lambdaRad0, phiRad0);
        if (llRad == null) {
            return null;
        }
        double lambda = Math.toDegrees(llRad[0]);
        double phi = Math.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        RaiszArmadillo raiszArmadillo = this;
        synchronized (raiszArmadillo) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double x;
                double[] llRad;
                int xMin;
                double phiRad;
                double lambdaRad;
                double y = (double)iy + 0.5;
                if (y >= this.ycentMin_ && y <= this.ycentMax_) {
                    lambdaRad = 1.0E-5;
                    phiRad = (this.latMin_ + (y - this.ycentMin_) / (this.ycentMax_ - this.ycentMin_) * (this.latMax_ - this.latMin_)) * (Math.PI / 180);
                    xMin = 0;
                } else {
                    if (!(y > this.yhornMin_) || !(y < this.yhornMax_)) continue;
                    if (this.tilt_ > 0.0) {
                        lambdaRad = 2.0 * Math.acos((this.yshift_ + this.cosTilt_ - y * this.invRS_) / this.sinTilt_);
                        phiRad = Math.toRadians(89.0);
                    } else if (this.tilt_ < 0.0) {
                        lambdaRad = 2.0 * Math.acos((this.yshift_ - this.cosTilt_ - y * this.invRS_) / this.sinTilt_);
                        phiRad = Math.toRadians(-89.0);
                    } else {
                        lambdaRad = 0.0;
                        phiRad = 0.0;
                    }
                    xMin = (int)(0.5 + this.rS_ * Math.sin(0.5 * lambdaRad));
                }
                for (int ix = xMin; ix < this.dxMax_ && (llRad = this.iterateXY2LLRad(x = (double)ix + 0.5, y, lambdaRad += 1.0E-5, phiRad += 1.0E-5)) != null; ++ix) {
                    lambdaRad = llRad[0];
                    phiRad = llRad[1];
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double findLatLimit(double dlambda) {
        double limitRad = -Math.atan(Math.cos(0.5 * Math.toRadians(dlambda)) / this.tanTilt_);
        return Math.toDegrees(limitRad);
    }

    private double[] iterateXY2LLRad(double x, double y, double lambdaRad0, double phiRad0) {
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double halfLambdaRad = 0.5 * lambdaRad;
            double cosHalfLambda = Math.cos(halfLambdaRad);
            double sinHalfLambda = Math.sin(halfLambdaRad);
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double onePlusCosPhi = 1.0 + Math.cos(phiRad);
            double f1 = onePlusCosPhi * sinHalfLambda - xOverRS;
            double f2 = this.yshift_ + this.cosTilt_ * sinPhi - this.sinTilt_ * onePlusCosPhi * cosHalfLambda - yOverRS;
            double df1dPhi = -sinHalfLambda * sinPhi;
            double df1dLambda = 0.5 * onePlusCosPhi * cosHalfLambda;
            double df2dPhi = this.cosTilt_ * cosPhi + this.sinTilt_ * cosHalfLambda * sinPhi;
            double df2dLambda = 0.5 * this.sinTilt_ * onePlusCosPhi * sinHalfLambda;
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (!(Math.abs(dphi) < 1.0E-5 & Math.abs(dlambda) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double phiLim = this.findLatLimit(Math.toDegrees(lambdaRad));
        if (this.tilt_ > 0.0 && phi < phiLim || this.tilt_ < 0.0 && phi > phiLim) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.borderCurves_ == null) {
            this.borderCurves_ = this.makeBorderBezier();
        }
        for (Bezier curve : this.borderCurves_) {
            if (curve == null) continue;
            curve.draw(g2d);
        }
        if (Math.abs(this.tilt_) < 1.0E-5) {
            double edgeLon = this.lambdaC_ + 179.99999;
            Point2D.Double dot = this.transformLL2XY(edgeLon, 90.0);
            g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y));
            g2d.draw(new Line2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y));
        }
    }

    private Bezier[] makeBorderBezier() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            return this.makeBorderBezier0();
        }
        ArrayList<Point2D.Double> alist1 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist2 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist3 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist4 = new ArrayList<Point2D.Double>(100);
        int np = 60;
        double npfact = 3.0;
        double edgeLon = this.lambdaC_ + 180.0;
        Point2D.Double lastDot = null;
        for (int j = 0; j <= 60; ++j) {
            Point2D.Double dot;
            double lat = 90.0 - 3.0 * (double)j;
            if (this.tilt_ < 0.0) {
                lat *= -1.0;
            }
            if ((dot = this.transformLL2XY(edgeLon - 0.001, lat)) == null) break;
            alist1.add(new Point2D.Double(dot.x, dot.y));
            alist2.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
            lastDot = dot;
        }
        if (lastDot != null) {
            alist3.add(new Point2D.Double(lastDot.x, lastDot.y));
            alist4.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - lastDot.x, lastDot.y));
        }
        double subtract = 0.0;
        while (subtract < 180.0) {
            subtract = subtract == 0.0 ? 0.001 : (Math.abs(this.tilt_) < 1.0 && subtract < 10.0 * Math.abs(this.tilt_) ? (subtract += 0.5 * Math.abs(this.tilt_)) : (subtract < 1.0 ? (subtract += 0.05) : (subtract < 5.0 ? (subtract += 0.4) : (subtract < 30.0 ? (subtract += 1.0) : (subtract < 60.0 ? (subtract += 2.0) : (subtract += 3.0))))));
            double dlon = Math.max(180.0 - subtract, 0.0);
            double latLimit = this.findLatLimit(dlon) + (this.tilt_ > 0.0 ? 0.01 : -0.01);
            Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + dlon - 0.01, latLimit);
            if (dot == null || dot.x > lastDot.x) continue;
            alist3.add(new Point2D.Double(dot.x, dot.y));
            alist4.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        }
        int ew = 60;
        double ewfact = 3.0;
        double plat = this.tilt_ > 0.0 ? 89.9 : -89.9;
        Point2D.Double[] dots5 = new Point2D.Double[121];
        for (int i = 0; i <= 60; ++i) {
            double dlon = 3.0 * (double)i;
            if (i == 60) {
                dlon -= 0.1;
            }
            Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + dlon, plat);
            dots5[60 - i] = new Point2D.Double(dot.x, dot.y);
            dots5[60 + i] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
        }
        return new Bezier[]{new Bezier(false, alist1), new Bezier(false, alist2), new Bezier(false, alist3), new Bezier(false, alist4), new Bezier(false, dots5)};
    }

    private Bezier[] makeBorderBezier0() {
        double edgeLon = this.lambdaC_ + 179.99999;
        int np = 30;
        double fact = 3.0;
        Point2D.Double[] dotsE = new Point2D.Double[61];
        Point2D.Double[] dotsW = new Point2D.Double[61];
        for (int j = 0; j <= 30; ++j) {
            double jj = 3.0 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[30 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[30 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[30 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[30 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        return new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

