/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PolynomialCylindrical
extends GlobalCylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private double a1_ = 1.0;
    private double c1_ = 1.0;
    private double c3_;
    private double c5_;
    private double c7_;
    private double c9_;
    private double threeC3_;
    private double fiveC5_;
    private double sevenC7_;
    private double nineC9_;
    private boolean maxNIs5_;

    public PolynomialCylindrical(String name, int width, int height, int xmargin, int ymargin) {
        super(name, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
    }

    protected final void setPolynomialConstants(double a1, double ... polyConstants) {
        if (polyConstants.length > 5) {
            LOGGER.error("Too many polynomial constants.");
            throw new RuntimeException("We are not yet coded to handle constants beyond C9");
        }
        this.a1_ = a1;
        this.c1_ = polyConstants[0];
        if (polyConstants.length > 1) {
            this.c3_ = polyConstants[1];
            if (polyConstants.length > 2) {
                this.c5_ = polyConstants[2];
                if (polyConstants.length > 3) {
                    this.c7_ = polyConstants[3];
                    if (polyConstants.length > 4) {
                        this.c9_ = polyConstants[4];
                    }
                }
            }
        }
        this.maxNIs5_ = this.c7_ == 0.0 && this.c9_ == 0.0;
        this.threeC3_ = 3.0 * this.c3_;
        this.fiveC5_ = 5.0 * this.c5_;
        this.sevenC7_ = 7.0 * this.c7_;
        this.nineC9_ = 9.0 * this.c9_;
        this.maxNIs5_ = false;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double wfactor = this.a1_ * Math.PI;
        double hfactor = this.maxNIs5_ ? 1.5707963267948966 * (this.c1_ + 2.4674011002723395 * (this.c3_ + this.c5_ * 2.4674011002723395)) : 1.5707963267948966 * (this.c1_ + 2.4674011002723395 * (this.c3_ + 2.4674011002723395 * (this.c5_ + 2.4674011002723395 * (this.c7_ + this.c9_ * 2.4674011002723395))));
        this.setMaxXYOverRS(wfactor, hfactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = this.a1_ * this.lonToLambdaRad(lon);
        double y = this.maxNIs5_ ? phiRad * (this.c1_ + phiRad2 * (this.c3_ + this.c5_ * phiRad2)) : phiRad * (this.c1_ + phiRad2 * (this.c3_ + phiRad2 * (this.c5_ + phiRad2 * (this.c7_ + this.c9_ * phiRad2))));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double lambdaRad = x * this.invRS_ / this.a1_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            double dfunc;
            double func;
            double phiRad2 = phiRad * phiRad;
            if (this.maxNIs5_) {
                func = phiRad * (this.c1_ + phiRad2 * (this.c3_ + this.c5_ * phiRad2)) - yOverRS;
                dfunc = this.c1_ + phiRad2 * (this.threeC3_ + phiRad2 * this.fiveC5_);
            } else {
                func = phiRad * (this.c1_ + phiRad2 * (this.c3_ + phiRad2 * (this.c5_ + phiRad2 * (this.c7_ + this.c9_ * phiRad2)))) - yOverRS;
                dfunc = this.c1_ + phiRad2 * (this.threeC3_ + phiRad2 * (this.fiveC5_ + phiRad2 * (this.sevenC7_ + this.nineC9_ * phiRad2)));
            }
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double phiRad = 1.0E-5;
        PolynomialCylindrical polynomialCylindrical = this;
        synchronized (polynomialCylindrical) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                phiRad += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    double dfunc;
                    double func;
                    double phiRad2 = phiRad * phiRad;
                    if (this.maxNIs5_) {
                        func = phiRad * (this.c1_ + phiRad2 * (this.c3_ + this.c5_ * phiRad2)) - yOverRS;
                        dfunc = this.c1_ + phiRad2 * (this.threeC3_ + phiRad2 * this.fiveC5_);
                    } else {
                        func = phiRad * (this.c1_ + phiRad2 * (this.c3_ + phiRad2 * (this.c5_ + phiRad2 * (this.c7_ + this.c9_ * phiRad2)))) - yOverRS;
                        dfunc = this.c1_ + phiRad2 * (this.threeC3_ + phiRad2 * (this.fiveC5_ + phiRad2 * (this.sevenC7_ + this.nineC9_ * phiRad2)));
                    }
                    double dphiRad = -func / dfunc;
                    phiRad += dphiRad;
                    if (Math.abs(dphiRad) < 1.0E-5) break;
                }
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_ / this.a1_) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

