/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Parabolic
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Parabolic";
    private static final double SQRT_3PI = 3.0699801238394655;
    private static final double SQRT_3OVERPI = 0.9772050238058397;
    private static final double MAX_X_OVER_RS = 3.0699801238394655;
    private static final double MAX_Y_OVER_RS = 1.5349900619197328;

    public Parabolic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Parabolic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 3.0699801238394655, 1.5349900619197328);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRadOver3 = Math.toRadians(lat) / 3.0;
        double x = 0.9772050238058397 * this.lonToLambdaRad(lon) * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0);
        double y = 3.0699801238394655 * Math.sin(phiRadOver3);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double invRSSqrt3Pi = 1.0 / (this.rS_ * 3.0699801238394655);
        double phiRad = 3.0 * Math.asin(y * invRSSqrt3Pi);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double rSSqrt3OverPi = this.rS_ * 0.9772050238058397;
        double lambdaRad = x / (rSSqrt3OverPi * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double rSSqrt3OverPi = this.rS_ * 0.9772050238058397;
        double invRSSqrt3Pi = 1.0 / (this.rS_ * 3.0699801238394655);
        Parabolic parabolic = this;
        synchronized (parabolic) {
            double y;
            double phiRad;
            double phi;
            for (int iy = 0; iy < this.dyMax_ && !((phi = Math.toDegrees(phiRad = 3.0 * Math.asin((y = (double)iy + 0.5) * invRSSqrt3Pi))) > 90.0); ++iy) {
                double xFactor = 1.0 / (rSSqrt3OverPi * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lambdaRad = x * xFactor;
                    if (lambdaRad > Math.PI) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

