/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Graphics2D;

public class Orthographic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Orthographic";
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 90.0;

    public Orthographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Orthographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addClipAngleParameter(90.0, 90.0, true);
        this.setAzimuthalFill(false);
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double rhoEdgeOverR = Math.sin(this.edgeAngleRad_);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.rS_;
        this.rhoBorder2_ = this.rS_ * this.rS_;
        this.fillCorners_ = this.edgeAngle_ < 90.0;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    @Override
    protected final double getZRadForRho(double rho) {
        double sinZ = rho * this.invRS_;
        return Math.asin(sinZ);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambda;
        if (this.phiC_ == 0.0 && Math.abs(90.0 - (lambda = Math.abs(this.lonToLambda(lon)))) < 1.0E-5) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

