/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class NaturalEarth2
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Natural Earth II";
    private static final double A1 = 0.84719;
    private static final double A2 = -0.13063;
    private static final double A3 = -0.04515;
    private static final double A4 = 0.05494;
    private static final double A5 = -0.02326;
    private static final double A6 = 0.00331;
    private static final double B1 = 1.01183;
    private static final double B2 = -0.02625;
    private static final double B3 = 0.01926;
    private static final double B4 = -0.00396;
    private static final double MAX_X_OVER_RS = 2.661525880194737;
    private static final double MAX_Y_OVER_RS = 1.424230405958047;

    public NaturalEarth2(int width, int height) {
        this(width, height, 0, 0);
    }

    public NaturalEarth2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.661525880194737, 1.424230405958047);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (phiRad == 0.0) {
            x = lambdaRad * 0.84719;
            y = 0.0;
        } else {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double phiRad6 = phiRad4 * phiRad2;
            double phiRad8 = phiRad6 * phiRad2;
            double phiRad10 = phiRad8 * phiRad2;
            double phiRad12 = phiRad10 * phiRad2;
            y = phiRad * (1.01183 + -0.02625 * phiRad8 + 0.01926 * phiRad10 + -0.00396 * phiRad12);
            x = lambdaRad == 0.0 ? 0.0 : lambdaRad * (0.84719 + -0.13063 * phiRad2 + phiRad12 * (-0.04515 + 0.05494 * phiRad2 + -0.02326 * phiRad4 + 0.00331 * phiRad6));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        if (y == 0.0) {
            phiRad = 0.0;
        } else {
            double yOverRS = y * this.invRS_;
            phiRad = this.iteratePhiRad(yOverRS, 1.5707963267948966 * y / this.ymRS_);
            if (Double.isNaN(phiRad)) {
                return null;
            }
        }
        if (x == 0.0) {
            lambdaRad = 0.0;
        } else if (phiRad == 0.0) {
            lambdaRad = x * this.invRS_ / 0.84719;
        } else {
            lambdaRad = x * this.xFactorForPhiRad(phiRad);
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        NaturalEarth2 naturalEarth2 = this;
        synchronized (naturalEarth2) {
            double y;
            double yOverRS;
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !Double.isNaN(phiRad = this.iteratePhiRad(yOverRS = (y = (double)iy + 0.5) * this.invRS_, phiRad + 1.0E-5)); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.xFactorForPhiRad(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    double lambda = Math.toDegrees(lambdaRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    private double xFactorForPhiRad(double phiRad) {
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double phiRad6 = phiRad4 * phiRad2;
        double phiRad8 = phiRad6 * phiRad2;
        double phiRad10 = phiRad8 * phiRad2;
        double phiRad12 = phiRad10 * phiRad2;
        return this.invRS_ / (0.84719 + -0.13063 * phiRad2 + phiRad12 * (-0.04515 + 0.05494 * phiRad2 + -0.02326 * phiRad4 + 0.00331 * phiRad6));
    }

    private double iteratePhiRad(double yOverRS, double firstGuess) {
        boolean found = false;
        double phiRad = firstGuess;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double phiRad6 = phiRad2 * phiRad2 * phiRad2;
            double phiRad8 = phiRad6 * phiRad2;
            double phiRad10 = phiRad8 * phiRad2;
            double phiRad12 = phiRad10 * phiRad2;
            double b2PhiRad8 = -0.02625 * phiRad8;
            double b3PhiRad10 = 0.01926 * phiRad10;
            double b4PhiRad12 = -0.00396 * phiRad12;
            double numerator = phiRad * (1.01183 + b2PhiRad8 + b3PhiRad10 + b4PhiRad12) - yOverRS;
            double denominator = 1.01183 + 9.0 * b2PhiRad8 + 11.0 * b3PhiRad10 + 13.0 * b4PhiRad12;
            double dphiRad = -numerator / denominator;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found || phiRad > 1.5707963267948966) {
            return Double.NaN;
        }
        return phiRad;
    }
}

