/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mollweide
extends InterruptedPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Mollweide";
    public static final int PROPERTIES = 16785416;
    private static final double CSUBX = 0.9003163161571062;
    private static final double CSUBY = 1.4142135623730951;
    private static final double CSUBX_B = 1.0;
    private static final double CSUBY_B = 1.2732395447351628;
    private static final double MAX_X_OVER_RS = 2.8284271247461903;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;
    private double cSubX_ = 0.9003163161571062;
    private double cSubY_ = 1.4142135623730951;
    private double xFactor0_;
    private final ProjBooleanParameter bromParam_;

    public Mollweide(int width, int height) {
        this(width, height, 0, 0);
    }

    public Mollweide(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16785416, width, height, xmargin, ymargin, 2.8284271247461903, 1.4142135623730951);
        ProjListParameter interrupt = (ProjListParameter)this.getParameter(0);
        interrupt.setDefault(Interruption.CONTS.toString());
        interrupt.setValue(Interruption.CONTS.toString());
        this.bromParam_ = new ProjBooleanParameter("Apply Bromley's scaling", "Apply Bromley's scaling", false);
        this.addParameter(this.bromParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.bromParam_) {
            this.setBromleyScaling(this.bromParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setBromleyScaling(boolean b) {
        if (b) {
            this.cSubX_ = 1.0;
            this.cSubY_ = 1.2732395447351628;
        } else {
            this.cSubX_ = 0.9003163161571062;
            this.cSubY_ = 1.4142135623730951;
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.setMaxXYOverRS(this.cSubX_ * Math.PI, this.cSubY_);
    }

    @Override
    protected final void finishScaling() {
        this.xFactor0_ = this.invRS_ / this.cSubX_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        if (lat > 89.99999) {
            if (this.isShowingInterrupted()) {
                return this.transformLL2XYIgnoreMargins(lon, 89.99999);
            }
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.cSubY_ * this.rS_);
        }
        if (lat < -89.99999) {
            if (this.isShowingInterrupted()) {
                return this.transformLL2XYIgnoreMargins(lon, -89.99999);
            }
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + this.cSubY_ * this.rS_);
        }
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double piSinPhi = Math.PI * sinPhi;
        double thetaRad = phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhi;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = this.cSubY_ * Math.sin(thetaRad);
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon) * this.cSubX_ * Math.cos(thetaRad);
            double cx = this.lonToLambdaRad(clon) * this.cSubX_;
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon) * this.cSubX_ * Math.cos(thetaRad);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double thetaRad = Math.asin(y * this.invRS_ / this.cSubY_);
        double phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.invRS_ / (this.cSubX_ * Math.cos(thetaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Mollweide mollweide = this;
        synchronized (mollweide) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double yFactor = yOverRS / this.cSubY_;
                if (yFactor > 1.0) continue;
                double thetaRad = Math.asin(yFactor);
                double twoThetaRad = 2.0 * thetaRad;
                double sinPhi = (twoThetaRad + Math.sin(twoThetaRad)) * 0.3183098861837907;
                double phiRad = Math.asin(sinPhi);
                double phi = Math.toDegrees(phiRad);
                if (phi == 90.0) {
                    this.setInvPoint(0, iy, 0.0, 90.0);
                    continue;
                }
                if (phi == -90.0) {
                    this.setInvPoint(0, iy, 0.0, -90.0);
                    continue;
                }
                double xFactor = this.invRS_ / (this.cSubX_ * Math.cos(thetaRad));
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

