/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class McBrydeThomas2
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde-Thomas II";
    private static final double CONST_P = 1.48875143;
    private static final double CONST_Q = 1.36508592;
    private static final double INV_Q = 0.7325546219098062;
    private static final double Q_OVER_P = 0.9169334064048557;
    private static final double CONST_K = 0.3056447;
    private static final double CONST_M = 1.3333333333333333;
    private static final double CONST_N = 1.4154628;
    private static final double INV_N = 0.7064827136396661;
    private static final double CAP_M = Math.sqrt(0.9419769515195547);
    private static final double CSUBX = CAP_M / 1.3333333333333333 * 0.3056447;
    private static final double CSUBY = 1.48875143 * CAP_M;
    private static final double P_TIMES_K = 0.455028984196921;
    private static final double MAX_X_OVER_RS = 2.8806312533925587;
    private static final double MAX_Y_OVER_RS = 1.48875143 * Math.sin(1.150694109272548);

    public McBrydeThomas2(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeThomas2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.8806312533925587, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double lambdaRad = this.lonToLambdaRad(lon);
        if (Math.abs(phiRad) > 1.0E-5) {
            double cosAlphaOverQ;
            double sinAlphaOverQ;
            double alphaOverQ;
            double cosAlpha;
            double nSinPhi = 1.4154628 * sinPhi;
            double alphaRad = 0.7853981633974483;
            for (int iter = 0; iter < 33; ++iter) {
                double sinAlpha = Math.sin(alphaRad);
                cosAlpha = Math.cos(alphaRad);
                alphaOverQ = alphaRad * 0.7325546219098062;
                sinAlphaOverQ = Math.sin(alphaOverQ);
                cosAlphaOverQ = Math.cos(alphaOverQ);
                double func = 0.455028984196921 * sinAlphaOverQ + sinAlpha - nSinPhi;
                double dfunc = 0.33333358547637865 * cosAlphaOverQ + cosAlpha;
                double dalphaRad = -func / dfunc;
                alphaRad += dalphaRad;
                if (Math.abs(dalphaRad) < 1.0E-5) break;
            }
            cosAlpha = Math.cos(alphaRad);
            alphaOverQ = alphaRad * 0.7325546219098062;
            sinAlphaOverQ = Math.sin(alphaOverQ);
            cosAlphaOverQ = Math.cos(alphaOverQ);
            x = CSUBX * lambdaRad * (1.0 + 3.0 * cosAlpha / cosAlphaOverQ);
            y = CSUBY * sinAlphaOverQ;
        } else {
            x = CSUBX * lambdaRad * 4.0;
            y = 0.0;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(yy) < 1.0E-5) {
            phiRad = 0.0;
            lambdaRad = x * this.invRS_ / (CSUBX * 4.0);
        } else {
            double sinAlphaOverQ = y * this.invRS_ / CSUBY;
            double alphaOverQ = Math.asin(sinAlphaOverQ);
            double alphaRad = 1.36508592 * alphaOverQ;
            double sinPhi = (0.455028984196921 * sinAlphaOverQ + Math.sin(alphaRad)) * 0.7064827136396661;
            if (Math.abs(sinPhi) > 1.0) {
                return null;
            }
            phiRad = Math.asin(sinPhi);
            lambdaRad = x * this.invRS_ / (CSUBX * (1.0 + 3.0 * Math.cos(alphaRad) / Math.cos(alphaOverQ)));
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        McBrydeThomas2 mcBrydeThomas2 = this;
        synchronized (mcBrydeThomas2) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double sinAlphaOverQ = y * this.invRS_ / CSUBY;
                double alphaOverQ = Math.asin(sinAlphaOverQ);
                double alphaRad = 1.36508592 * alphaOverQ;
                double sinPhi = (0.455028984196921 * sinAlphaOverQ + Math.sin(alphaRad)) * 0.7064827136396661;
                if (Math.abs(sinPhi) > 1.0) continue;
                double phiRad = Math.asin(sinPhi);
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ / (CSUBX * (1.0 + 3.0 * Math.cos(alphaRad) / Math.cos(alphaOverQ)));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

