/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loximuthal
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Loximuthal";
    private static final double PI_OVER_4 = 0.7853981633974483;
    public static final int PROPERTIES = 8;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private static final double DEFAULT_PHI1 = 40.0;
    private double phi1Rad_;
    private double cosPhi1_;
    private double tanPhi1Term_;
    private double yshift_;
    private final ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of reference parallel", "Reference Lat.", "\u00b0N", 40.0, -90.0, 90.0, false, false);

    public Loximuthal(int width, int height) {
        this(width, height, 0, 0);
    }

    public Loximuthal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.phi1Param_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.phi1Param_) {
            this.setReferenceParallel(this.phi1Param_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setReferenceParallel(double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Lat must be in range [-90\u0080,90\u0080].");
        }
        this.phi1Rad_ = Math.toRadians(lat);
        this.cosPhi1_ = Math.cos(this.phi1Rad_);
        this.tanPhi1Term_ = Math.tan(0.7853981633974483 + 0.5 * this.phi1Rad_);
        this.yshift_ = this.phi1Rad_;
        this.autoscale();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiFactor;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double dphiRad = phiRad - this.phi1Rad_;
        if (Math.abs(dphiRad) < 1.0E-10) {
            phiFactor = this.cosPhi1_;
        } else if (Math.abs(lambdaRad) < 1.0E-10) {
            phiFactor = 0.0;
        } else if (absLat > 89.99999) {
            phiFactor = 0.0;
        } else {
            double tanPhiTerm = Math.tan(0.7853981633974483 + 0.5 * phiRad);
            double logTerm = Math.log(tanPhiTerm / this.tanPhi1Term_);
            phiFactor = dphiRad / logTerm;
        }
        double x = lambdaRad * phiFactor;
        double y = this.yshift_ + dphiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_ - this.yshift_;
        double dphiRad = yOverRS;
        double phiRad = dphiRad + this.phi1Rad_;
        double phi = Math.toDegrees(phiRad);
        if (phi > 89.9999999999 || phi < -89.9999999999) {
            if (xOverRS > 1.0E-10) {
                return null;
            }
            lambdaRad = 0.0;
        } else {
            double phiFactor;
            if (Math.abs(dphiRad) < 1.0E-10) {
                phiFactor = 1.0 / this.cosPhi1_;
            } else {
                double tanPhiTerm = Math.tan(0.7853981633974483 + 0.5 * phiRad);
                double logTerm = Math.log(tanPhiTerm / this.tanPhi1Term_);
                phiFactor = dphiRad / logTerm;
            }
            lambdaRad = xOverRS / phiFactor;
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
        }
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Loximuthal loximuthal = this;
        synchronized (loximuthal) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRS;
                double lambdaRad;
                double phiFactor;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - this.yshift_;
                double dphiRad = yOverRS;
                double phiRad = dphiRad + this.phi1Rad_;
                double phi = Math.toDegrees(phiRad);
                if (phi > 89.9999999999 || phi < -89.9999999999) continue;
                if (Math.abs(dphiRad) < 1.0E-10) {
                    phiFactor = this.cosPhi1_;
                } else {
                    double tanPhiTerm = Math.tan(0.7853981633974483 + 0.5 * phiRad);
                    double logTerm = Math.log(tanPhiTerm / this.tanPhi1Term_);
                    phiFactor = dphiRad / logTerm;
                }
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) / phiFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves;
        for (Bezier curve : curves = this.makeBorderBezier()) {
            if (curve == null) continue;
            curve.draw(g2d);
        }
    }

    private Bezier[] makeBorderBezier() {
        ArrayList<Point2D.Double> alist1 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist2 = new ArrayList<Point2D.Double>(100);
        int np = 270;
        double npfact = 0.6666666666666666;
        double edgeLon = this.lambdaC_ + 180.0;
        for (int j = 0; j <= 270; ++j) {
            double lon = edgeLon - 0.001;
            double lat = 90.0 - 0.6666666666666666 * (double)j;
            Point2D.Double dot = this.transformLL2XY(lon, lat);
            if (dot == null) continue;
            alist1.add(new Point2D.Double(dot.x, dot.y));
            alist2.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        }
        return new Bezier[]{new Bezier(false, alist1), new Bezier(false, alist2)};
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

