/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.map.proj.ui.ProjBooleanComponent;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambertLagrange
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Lambert-Lagrange";
    public static final int PROPERTIES = 4128;
    private static final double MAX_X_OVER_RS = 1.0;
    private static final double MAX_Y_OVER_RS = 1.0;
    private static final double DEFAULT_N = 2.0;
    private static final double MIN_N = 0.25;
    private static final double MIN_GLOBAL_N = 1.2;
    private static final double MAX_N = 5.0;
    private double nParam_ = 2.0;
    private double invN_ = 1.0;
    private double nPi_ = 1.0;
    private double nPiOver2_ = 1.0;
    private boolean circleOnly_;
    private final ProjDoubleParameter scalingParam_ = new ProjDoubleParameter("Meridional scaling", "Scaling", "(0.25 \u2264 n \u2264 5.0)", 2.0, 0.25, 5.0, true, true);
    private final ProjBooleanParameter centerParam_ = new ProjBooleanParameter("Show central circle only", "Show central circle only", false);

    public LambertLagrange(int width, int height) {
        this(width, height, 0, 0);
    }

    public LambertLagrange(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4128, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.scalingParam_);
        this.addParameter(this.centerParam_);
        this.updateParamComponents();
        this.finishConstruction();
    }

    @Override
    public final void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setScaling(this.scalingParam_.getValue());
            this.setCircleOnly(this.centerParam_.isSelected());
        } else if (p == this.scalingParam_) {
            this.setScaling(this.scalingParam_.getValue());
        } else if (p == this.centerParam_) {
            this.setCircleOnly(this.centerParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        this.updateParamComponents();
    }

    public final void setScaling(double n) {
        if (n < 0.25 || n > 5.0) {
            throw new IllegalArgumentException("Parameter 'n' outside reasonable range.");
        }
        this.nParam_ = n;
        this.invN_ = 1.0 / n;
        this.nPi_ = n * Math.PI;
        this.nPiOver2_ = 0.5 * this.nPi_;
        if (this.nParam_ < 1.2) {
            this.circleOnly_ = true;
        }
        this.updateParamComponents();
    }

    private void setCircleOnly(boolean circle) {
        LOGGER.trace("circ {}", (Object)circle);
        this.circleOnly_ = this.nParam_ < 1.2 ? true : circle;
    }

    @Override
    protected final void prepareScaling() {
        double hf;
        double wf;
        if (this.circleOnly_ && this.nParam_ < 2.0) {
            wf = 1.0;
            hf = 1.0;
        } else if (this.nParam_ == 2.0) {
            wf = 1.0;
            hf = 1.0;
        } else {
            double piOverN = Math.PI * this.invN_;
            double cosPiOverN = Math.cos(piOverN);
            wf = Math.sin(piOverN) / (1.0 + cosPiOverN);
            if (this.nParam_ < 2.0) {
                double coshMuOverN = -1.0 / cosPiOverN;
                double muRadOverN = MathUtils.arcosh(coshMuOverN);
                double denom = coshMuOverN + cosPiOverN;
                hf = Math.sinh(muRadOverN) / denom;
            } else {
                double phiRad = 1.5707963267948966;
                double muRad = Math.log(Math.tan(1.5707963267948966));
                double muRadOverN = muRad * this.invN_;
                hf = Math.sinh(muRadOverN) / (Math.cosh(muRadOverN) + 1.0);
            }
        }
        this.setMaxXYOverRS(wf, hf);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        if (absLat > 89.99999) {
            double x2 = 0.0;
            double phiRad = 1.5707963267948966;
            double muRad = Math.log(Math.tan(1.5707963267948966));
            double muRadOverN = muRad * this.invN_;
            double y2 = Math.sinh(muRadOverN) / (Math.cosh(muRadOverN) + 1.0);
            if (lat < 0.0) {
                y2 = -y2;
            }
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y2 = (double)this.outCenterY_ - y2 * this.rS_;
            return new Point2D.Double(x2, y2);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double abslambdaRad = Math.abs(lambdaRad);
        if (this.circleOnly_ && abslambdaRad > this.nPiOver2_) {
            return null;
        }
        double lambdaRadOverN = Math.abs(lambdaRad) * this.invN_;
        if (lat == 0.0) {
            x = Math.sin(lambdaRadOverN) / (1.0 + Math.cos(lambdaRadOverN));
            y = 0.0;
        } else {
            double phiRad = Math.abs(Math.toRadians(lat));
            double muRad = Math.log(Math.tan(0.5 * (1.5707963267948966 + phiRad)));
            double muRadOverN = muRad * this.invN_;
            if (lambdaRadOverN < 1.0E-5) {
                double denom = Math.cosh(muRadOverN) + 1.0;
                x = 0.0;
                y = Math.sinh(muRadOverN) / denom;
            } else {
                double denom = Math.cosh(muRadOverN) + Math.cos(lambdaRadOverN);
                x = Math.sin(lambdaRadOverN) / denom;
                y = Math.sinh(muRadOverN) / denom;
            }
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double yOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double xOverRS = Math.abs(x * this.invRS_);
        double oneMinusX2MinusY2 = 1.0 - xOverRS * xOverRS - (yOverRS = Math.abs(y * this.invRS_)) * yOverRS;
        double tanLambdaOverN = Math.abs(oneMinusX2MinusY2) < 1.0E-5 ? this.nPi_ : 2.0 * xOverRS / oneMinusX2MinusY2;
        double lambdaRad = this.nParam_ * Math.atan(tanLambdaOverN);
        if (lambdaRad < 0.0) {
            if (this.circleOnly_) {
                return null;
            }
            lambdaRad += this.nPi_;
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double tanhMuOverN = 2.0 * yOverRS / (1.0 + xOverRS * xOverRS + yOverRS * yOverRS);
        double muRad = this.nParam_ * MathUtils.artanh(tanhMuOverN);
        double eToPower2Mu = Math.exp(2.0 * muRad);
        double sinPhi = (eToPower2Mu - 1.0) / (eToPower2Mu + 1.0);
        double phiRad = Math.asin(sinPhi);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void calculateInverseArray() {
        LambertLagrange lambertLagrange = this;
        synchronized (lambertLagrange) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double tanhMuOverN;
                    double muRad;
                    double eToPower2Mu;
                    double sinPhi;
                    double phiRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double oneMinusX2MinusY2 = 1.0 - xOverRS * xOverRS - yOverRS * yOverRS;
                    double tanLambdaOverN = Math.abs(oneMinusX2MinusY2) < 1.0E-5 ? this.nPi_ : 2.0 * xOverRS / oneMinusX2MinusY2;
                    double lambdaRad = this.nParam_ * Math.atan(tanLambdaOverN);
                    if (lambdaRad < 0.0) {
                        if (this.circleOnly_) continue block3;
                        lambdaRad += this.nPi_;
                    }
                    if (lambdaRad > Math.PI || (phiRad = Math.asin(sinPhi = ((eToPower2Mu = Math.exp(2.0 * (muRad = this.nParam_ * MathUtils.artanh(tanhMuOverN = 2.0 * yOverRS / (1.0 + xOverRS * xOverRS + yOverRS * yOverRS))))) - 1.0) / (eToPower2Mu + 1.0))) > 1.5707963267948966) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected final void drawBorderLines(Graphics2D g2d) {
        if (this.nParam_ == 2.0) {
            ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
        } else if (this.circleOnly_ && this.nParam_ < 2.0) {
            ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
        } else {
            this.drawMeridian(g2d, this.lambdaC_ + 179.99999, null);
            this.drawMeridian(g2d, this.lambdaC_ - 179.99999, null);
        }
    }

    @Override
    protected final void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - this.xmRS_, this.outCenterY_, (double)this.outCenterX_ + this.xmRS_, this.outCenterY_);
        } else {
            double dlon = this.circleOnly_ && this.nParam_ < 2.0 ? this.nParam_ * 90.0 : 180.0;
            double llon = this.lambdaC_ - dlon + 1.0E-10;
            double rlon = this.lambdaC_ + dlon - 1.0E-10;
            try {
                Point2D.Double dot1 = this.transformLL2XY(llon, lat);
                Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_, lat);
                Point2D.Double dot3 = this.transformLL2XY(rlon, lat);
                GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
            }
            catch (Exception exc) {
                LOGGER.debug("Got null for a dot on arc of parallel " + lat);
            }
        }
    }

    @Override
    protected final void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambdaRad = this.lonToLambdaRad(lon);
        if (this.circleOnly_ && Math.abs(lambdaRad) > this.nPiOver2_) {
            return;
        }
        double absLambda = Math.abs(lambdaRad);
        if (absLambda > 179.99999) {
            return;
        }
        Point2D.Double np2d = this.transformLL2XYIgnoreMargins(lon, 90.0);
        Point2D.Double sp2d = this.transformLL2XYIgnoreMargins(lon, -90.0);
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, np2d.x, np2d.y, sp2d.x, sp2d.y);
        } else {
            Point2D.Double ep2d = this.transformLL2XYIgnoreMargins(lon, 0.0);
            GraphicUtils.drawCircularArc(g2d, np2d.x, np2d.y, ep2d.x, ep2d.y, sp2d.x, sp2d.y);
        }
    }

    @Override
    protected final void updateParamComponents() {
        if (PlatformUtils.isHeadless()) {
            return;
        }
        if (this.centerParam_ != null) {
            EventQueue.invokeLater(() -> {
                ProjBooleanComponent bpc = (ProjBooleanComponent)this.getParamComponent(this.centerParam_);
                if (bpc == null) {
                    LOGGER.trace("Max angle component is null.");
                    return;
                }
                if (this.nParam_ < 1.2) {
                    bpc.setSelected(true);
                }
                bpc.setEnabled(this.nParam_ >= 1.2 && this.nParam_ <= 2.0);
            });
        }
    }
}

