/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Kavraisky5
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Kavraisky V";
    private static final double CONST_C = Math.toRadians(35.0) / Math.acos(0.9);
    private static final double Q_OVER_P = 0.9;
    private static final double P_OVER_Q = 1.1111111111111112;
    private static final double CONST_P = CONST_C * 1.1111111111111112;
    private static final double MAX_X_OVER_RS = 2.827433388230814;
    private static final double MAX_Y_OVER_RS = CONST_P * Math.sin(1.5707963267948966 / CONST_C);

    public Kavraisky5(int width, int height) {
        this(width, height, 0, 0);
    }

    public Kavraisky5(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.827433388230814, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double phiOverQ = phiRad / CONST_C;
        double x = 0.9 * this.lonToLambdaRad(lon) * Math.cos(phiRad) / Math.cos(phiOverQ);
        double y = CONST_P * Math.sin(phiOverQ);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double invPRS = this.invRS_ / CONST_P;
        double phiRad = CONST_C * Math.asin(y * invPRS);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double pOverQRS = 1.1111111111111112 * this.invRS_;
        double lambdaRad = x * pOverQRS * Math.cos(phiRad / CONST_C) / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Kavraisky5 kavraisky5 = this;
        synchronized (kavraisky5) {
            double y;
            double phiRad;
            double invPRS = this.invRS_ / CONST_P;
            double pOverQRS = 1.1111111111111112 * this.invRS_;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = CONST_C * Math.asin((y = (double)iy + 0.5) * invPRS)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = pOverQRS * Math.cos(phiRad / CONST_C) / Math.cos(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

