/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamesAzimuthal
extends AzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "James Azimuthal";
    public static final int PROPERTIES = 0x200040;
    private static final double JAMES_D = 1.5;
    private static final double CLARKE_D = 1.36666666666667;
    private static final double EDGE_RADIUS = 113.5;
    private static final double EDGE_RADIUS_RAD = Math.toRadians(113.5);
    private static final double COS_EDGE = Math.cos(EDGE_RADIUS_RAD);
    private static final double SIN_EDGE = Math.sin(EDGE_RADIUS_RAD);
    private final ProjBooleanParameter distParam_ = new ProjBooleanParameter("Apply Clarke's projection point distance", "Apply Clarke's proj. pt. D", false);
    private double dPerspective_ = 1.5;
    private double radiusFactor_;

    public JamesAzimuthal(int width, int height) {
        this(width, height, 0, 0);
    }

    public JamesAzimuthal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.distParam_);
        this.edgeAngle_ = 113.5;
        super.setAzimuthalFill(false);
        this.finishConstruction();
    }

    @Override
    public final void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.distParam_) {
            this.setClarkeDistance(this.distParam_.isSelected());
        }
    }

    @Override
    public final void setEdgeAngle(double angle) {
        LOGGER.debug("Clip angle param is not used by this projection");
    }

    @Override
    public final void setAzimuthalFill(boolean fill) {
        LOGGER.debug("Fill param is not used by this projection");
    }

    public final void setClarkeDistance(boolean b) {
        this.dPerspective_ = b ? 1.36666666666667 : 1.5;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.radiusFactor_ = this.dPerspective_ * SIN_EDGE / (this.dPerspective_ + COS_EDGE);
        this.setMaxXYOverRS(this.radiusFactor_);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.radiusFactor_ * this.rS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < COS_EDGE) {
            return -1.0;
        }
        return this.dPerspective_ / (this.dPerspective_ + cosZ);
    }

    @Override
    protected final double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double dOverRho = this.dPerspective_ / rhoOverRS;
        double z = rhoOverRS;
        for (int iter = 0; iter < 33; ++iter) {
            double sinZ = Math.sin(z);
            double cosZ = Math.cos(z);
            double func = this.dPerspective_ + cosZ - dOverRho * sinZ;
            double dfunc = -sinZ - dOverRho * cosZ;
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

