/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Guyou
extends QuadSymmetricProjection {
    public static final String PROJECTION_NAME = "Guyou";
    public static final int PROPERTIES = 4096;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double MAX_X_OVER_RS = 1.854074677301372;
    private static final double MAX_Y_OVER_RS = 1.854074677301372;

    public Guyou(int width, int height) {
        this(width, height, 0, 0);
    }

    public Guyou(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 1.854074677301372, 1.854074677301372);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double cosB;
        double cosA;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, 1.854074677301372 * this.rS_);
        }
        if (lat < -89.99999) {
            return new Point2D.Double(this.outCenterX_, -1.854074677301372 * this.rS_);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        if (absPhiRad > 1.5707963266948965) {
            double x = this.outCenterX_;
            double y = phiRad > 0.0 ? (double)this.outCenterY_ - 1.854074677301372 * this.rS_ : (double)this.outCenterY_ + 1.854074677301372 * this.rS_;
            return new Point2D.Double(x, y);
        }
        double cosPhi = Math.cos(absPhiRad);
        double sinPhi = Math.sin(absPhiRad);
        double sinLambda = Math.sin(absLambdaRad);
        if (absLambdaRad < 1.0E-10) {
            cosA = -0.7071067811865476 * sinPhi;
            cosB = 0.7071067811865476 * sinPhi;
        } else if (absPhiRad < 1.0E-10) {
            cosA = 0.7071067811865476 * sinLambda;
            cosB = 0.7071067811865476 * sinLambda;
        } else {
            cosA = 0.7071067811865476 * (cosPhi * sinLambda - sinPhi);
            cosB = 0.7071067811865476 * (cosPhi * sinLambda + sinPhi);
        }
        double sinA = Math.sqrt(1.0 - cosA * cosA);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double cosAcosB = cosA * cosB;
        double sinAsinB = sinA * sinB;
        double sinM = Math.sqrt(1.0 + cosAcosB - sinAsinB);
        double sinN = Math.sqrt(1.0 - cosAcosB - sinAsinB);
        double mmm = Math.asin(sinM);
        double nnn = Math.asin(sinN);
        double x = Elliptic.ellipticF(mmm, 0.5000000000000001);
        double y = Elliptic.ellipticF(nnn, 0.5000000000000001);
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (phiRad < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = Math.abs(x) * this.invRS_;
        double yOverRS = Math.abs(y) * this.invRS_;
        double[] absLL = this.transformAbsXYrs2LL(xOverRS, yOverRS);
        double lambda = absLL[0];
        double phi = absLL[1];
        if (y < 0.0) {
            phi = -phi;
        }
        if (x < 0.0) {
            lambda = -lambda;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Guyou guyou = this;
        synchronized (guyou) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double[] absLL = this.transformAbsXYrs2LL(xOverRS, yOverRS);
                    this.setInvPoints(ix, iy, absLL[0], absLL[1]);
                }
            }
        }
    }

    private double[] transformAbsXYrs2LL(double xOverRS, double yOverRS) {
        double[] jacobiM = Elliptic.jacobiSnCnDn(xOverRS, 0.5000000000000001);
        double[] jacobiN = Elliptic.jacobiSnCnDn(yOverRS, 0.5000000000000001);
        double sinM = jacobiM[0];
        double sinN = jacobiN[0];
        double sinSqM = sinM * sinM;
        double sinSqN = sinN * sinN;
        double sinAsinB = -0.5 * (sinSqM + sinSqN - 2.0);
        double cosAcosB = 0.5 * (sinSqM - sinSqN);
        double cosAplusB = cosAcosB - sinAsinB;
        double cosAminusB = cosAcosB + sinAsinB;
        double aPlusB = Math.acos(cosAplusB);
        double aMinusB = Math.acos(cosAminusB);
        double a = 0.5 * (aPlusB + aMinusB);
        double b = 0.5 * (aPlusB - aMinusB);
        double cosA = Math.cos(a);
        double cosB = Math.cos(b);
        double sinPhi = 0.7071067811865476 * (cosB - cosA);
        double phiRad = Math.asin(sinPhi);
        double cosPhi = Math.cos(phiRad);
        double sinLambda = 0.7071067811865476 * (cosA + cosB) / cosPhi;
        double lambdaRad = Math.asin(sinLambda);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new double[]{lambda, phi};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double dd = this.rS_ * 1.854074677301372;
        ProjectionUtils.drawRectBorder(g2d, (double)this.outCenterX_ - dd, (double)this.outCenterY_ - dd, 2.0 * dd, 2.0 * dd);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) < 1.0E-5) {
            double ll = (double)this.outCenterX_ - this.rS_ * 1.854074677301372;
            double rr = (double)this.outCenterX_ + this.rS_ * 1.854074677301372;
            GraphicUtils.drawLine(g2d, ll, this.outCenterY_, rr, this.outCenterY_);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 89.99999) {
            return;
        }
        if (absLambda < 1.0E-5) {
            double tt = (double)this.outCenterY_ - this.rS_ * 1.854074677301372;
            double bb = (double)this.outCenterY_ + this.rS_ * 1.854074677301372;
            GraphicUtils.drawLine(g2d, this.outCenterX_, tt, this.outCenterX_, bb);
        } else {
            super.drawMeridian(g2d, lon, label);
        }
    }
}

