/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;

public class GottMugnoloAzimuthal2H
extends TwoHemisphereAzimuthalProjection {
    public static final String PROJECTION_NAME = "Gott-Mugnolo Azimuthal (Two-Hemisphere)";
    public static final int PROPERTIES = 0x2200040;
    private static final double CONST_A = 0.446;
    private static final double INV_A = 2.242152466367713;
    private static final double RADIUS_FACTOR = Math.sin(0.7005751617505239);

    public GottMugnoloAzimuthal2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public GottMugnoloAzimuthal2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x2200040, width, height, xmargin, ymargin, RADIUS_FACTOR);
        this.finishConstruction();
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        double cosZ = Math.cos(phiPRad) * Math.cos(lambdaPRad);
        if (cosZ == 1.0) {
            return 0.0;
        }
        double z = Math.acos(cosZ);
        return Math.sin(0.446 * z) / Math.sin(z);
    }

    @Override
    protected double getZRadForRho(double rho) {
        return 2.242152466367713 * Math.asin(rho * this.invRS_);
    }
}

