/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class GoodeHomolosine
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Goode Homolosine";
    public static final int PROPERTIES = 0x100000A;
    private static final double JOIN_LAT = 40.7366621897;
    private static final double YSHIFT = 0.0528;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.3614135623730952;
    private double joinYRS_;

    public GoodeHomolosine(int width, int height) {
        this(width, height, 0, 0);
    }

    public GoodeHomolosine(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x100000A, width, height, xmargin, ymargin, Math.PI, 1.3614135623730952);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.joinYRS_ = Math.toRadians(40.7366621897) * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - 1.3614135623730952 * this.rS_);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + 1.3614135623730952 * this.rS_);
        }
        double phiRad = Math.toRadians(lat);
        double thetaRad = 0.0;
        if (absLat > 40.7366621897) {
            double piSinPhi = Math.PI * Math.sin(phiRad);
            thetaRad = phiRad;
            for (int iter = 0; iter < 33; ++iter) {
                double twoThetaRad = 2.0 * thetaRad;
                double dthetaRad = 0.5 * (piSinPhi - twoThetaRad - Math.sin(twoThetaRad)) / (1.0 + Math.cos(twoThetaRad));
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = 1.4142135623730951 * Math.sin(thetaRad);
            y = lat > 0.0 ? (y -= 0.0528) : (y += 0.0528);
        } else {
            y = phiRad;
        }
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon);
            dx = absLat > 40.7366621897 ? (dx *= 1.4142135623730951 * Math.cos(thetaRad) * 0.6366197723675814) : (dx *= Math.cos(phiRad));
            double cx = this.lonToLambdaRad(clon);
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon);
            x = absLat > 40.7366621897 ? (x *= 1.4142135623730951 * Math.cos(thetaRad) * 0.6366197723675814) : (x *= Math.cos(phiRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinYRS_) {
            double yOverRS = Math.abs(y) * this.invRS_ + 0.0528;
            double thetaRad = Math.asin(yOverRS * 0.7071067811865476);
            phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = 1.5707963267948966 * this.invRS_ * 0.7071067811865476 / Math.cos(thetaRad);
        } else {
            phiRad = y * this.invRS_;
            xFactor = this.invRS_ / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GoodeHomolosine goodeHomolosine = this;
        synchronized (goodeHomolosine) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double xFactor;
                double phiRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                if (Math.abs(y) > this.joinYRS_) {
                    yOverRS = y > 0.0 ? (yOverRS += 0.0528) : (yOverRS -= 0.0528);
                    double thetaRad = Math.asin(yOverRS * 0.7071067811865476);
                    phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
                    if (phiRad < -1.5707963267948966) continue;
                    if (phiRad > 1.5707963267948966) break;
                    xFactor = 1.5707963267948966 * this.invRS_ * 0.7071067811865476 / Math.cos(thetaRad);
                } else {
                    phiRad = y * this.invRS_;
                    xFactor = this.invRS_ / Math.cos(phiRad);
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

