/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class Gnomonic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Gnomonic";
    private static final double MAX_CLIP_ANGLE = 85.0;
    private static final double DEFAULT_CLIP_ANGLE = 15.0;

    public Gnomonic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Gnomonic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addClipAngleParameter(15.0, 85.0, true);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double rhoEdgeOverR = 1.0 / Math.tan(1.5707963267948966 - this.edgeAngleRad_);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.fillCorners_ ? this.rS_ / Math.tan(1.5707963267948966 - Math.toRadians(85.0)) : this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ <= 0.0) {
            return -1.0;
        }
        return 1.0 / cosZ;
    }

    @Override
    protected double getZRadForRho(double rho) {
        return Math.atan(rho * this.invRS_);
    }
}

