/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalPseudocylindric
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 8;
    private boolean global_ = true;

    public GlobalPseudocylindric(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Point2D.Double dot;
        Bezier[] curves = this.makeOuterBeziers();
        if (curves != null) {
            if (curves[0] != null) {
                curves[0].draw(g2d);
            }
            if (curves[1] != null) {
                curves[1].draw(g2d);
            }
        }
        if ((dot = this.transformLL2XY(this.lambdaC_ + 179.99999, 90.0)) == null) {
            LOGGER.debug("Error getting NP dot");
            return;
        }
        if (Math.abs(dot.x - (double)this.outCenterX_) < 1.0E-5) {
            return;
        }
        g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        g2d.draw(new Line2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y));
    }

    public boolean isGlobal() {
        return this.global_;
    }

    protected final void setGlobalProt(boolean global) {
        this.global_ = global;
        this.autoscale();
    }

    protected Bezier[] makeOuterBeziers() {
        double edgeLon = this.lambdaC_ + 179.99999;
        int np = 105;
        double fact = 0.8571428571428571;
        Point2D.Double[] dotsE = new Point2D.Double[211];
        Point2D.Double[] dotsW = new Point2D.Double[211];
        for (int j = 0; j <= 105; ++j) {
            double jj = 0.8571428571428571 * (double)j;
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(edgeLon, jj);
            if (dot == null) {
                LOGGER.debug("Got null XY for border lon {}, lat {}", (Object)edgeLon, (Object)jj);
                return null;
            }
            dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        return new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double llon = this.global_ ? this.lambdaC_ - 179.99999 : this.lambdaC_ - 89.99999;
        double rlon = this.global_ ? this.lambdaC_ + 179.99999 : this.lambdaC_ + 89.99999;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        Shape oldclip = g2d.getClip();
        if (label != null) {
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = (float)(dot2.x - (double)fh2 - (double)w);
            g2d.drawString(label, labelx, (float)(dot1.y + (double)fh2 - (double)(des / 2)));
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot1.y - (double)fh2, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2d.setClip(clipArea);
        }
        GraphicUtils.drawLine(g2d, dot1, dot2);
        g2d.setClip(oldclip);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (this.global_ && absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

