/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class Ginzburg2
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Ginzburg II";
    private static final double CONST_A = 2.5E-4;
    private static final double CONST_Q = 10.0;
    private static final double AQ = 0.0025;
    private static final double Q_MINUS_1 = 9.0;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 90.0;

    public Ginzburg2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Ginzburg2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addClipAngleParameter(90.0, 90.0, true);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double rhoEdgeOverR = 2.0 * Math.sin(0.5 * this.edgeAngleRad_) + 2.5E-4 * Math.pow(this.edgeAngleRad_, 10.0);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = 1.4142135623730951 + 2.5E-4 * Math.pow(1.5707963267948966, 10.0);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        double z = Math.acos(cosZ);
        double rho = 2.0 * Math.sin(0.5 * z) + 2.5E-4 * Math.pow(z, 10.0);
        double rho2 = rho * rho;
        if (rho2 * this.r2s2_ > this.rhoBorder2_) {
            return -1.0;
        }
        return rho / Math.sin(z);
    }

    @Override
    protected double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double z = rhoOverRS * 1.5707963267948966;
        for (int iter = 0; iter < 33; ++iter) {
            double halfZ = 0.5 * z;
            double sinHalfZ = Math.sin(halfZ);
            double cosHalfZ = Math.cos(halfZ);
            double func = 2.0 * sinHalfZ + 2.5E-4 * Math.pow(z, 10.0) - rhoOverRS;
            double dfunc = cosHalfZ + 0.0025 * Math.pow(z, 9.0);
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

