/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class GallBomfordPseudocylindrical
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Gall-Bomford Pseudocylindrical";
    private static final double TWO_PLUS_SQRT2 = 3.414213562373095;
    private static final double TERM2 = 1.7071067811865475;
    private static final double TERM3 = 0.585786437626905;
    private static final double MAX_X_OVER_RS = 2.221441469079183;
    private static final double MAX_Y_OVER_RS = 1.7071067811865475 * Math.tan(Math.toRadians(45.0));

    public GallBomfordPseudocylindrical(int width, int height) {
        this(width, height, 0, 0);
    }

    public GallBomfordPseudocylindrical(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.221441469079183, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double tanHalfPhi = Math.tan(0.5 * phiRad);
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double x = this.lonToLambdaRad(lon) * 0.7071067811865476 * (1.0 - 0.04 * phiRad4);
        double y = 1.7071067811865475 * tanHalfPhi;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(y * this.invRS_ * 0.585786437626905);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double lambdaRad = x * this.invRS_ * 1.4142135623730951 / (1.0 - 0.04 * phiRad4);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GallBomfordPseudocylindrical gallBomfordPseudocylindrical = this;
        synchronized (gallBomfordPseudocylindrical) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.invRS_ * 0.585786437626905)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double phiRad2 = phiRad * phiRad;
                double phiRad4 = phiRad2 * phiRad2;
                double xFactor = this.invRS_ * 1.4142135623730951 / (1.0 - 0.04 * phiRad4);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

