/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class FoucautStereographic
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Foucaut Stereographic";
    private static final double CONST_P = 1.772453850905516;
    private static final double CONST_C = 2.0;
    private static final double INV_P = 0.5641895835477563;
    private static final double INV_Q = 0.5;
    private static final double Q_OVER_P = 1.1283791670955126;
    private static final double P_OVER_Q = 0.886226925452758;
    private static final double MAX_X_OVER_RS = 3.5449077018110318;
    private static final double MAX_Y_OVER_RS = 1.772453850905516 * Math.tan(0.7853981633974483);

    public FoucautStereographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public FoucautStereographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 3.5449077018110318, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double phiOverQ = phiRad * 0.5;
        double cosPhiOverQ = Math.cos(phiOverQ);
        double x = 1.1283791670955126 * this.lonToLambdaRad(lon) * Math.cos(phiRad) * cosPhiOverQ * cosPhiOverQ;
        double y = 1.772453850905516 * Math.tan(phiOverQ);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(y * this.invRS_ * 0.5641895835477563);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (phiRad == 1.5707963267948966) {
            return new PointLL(this.lambdaC_, 90.0);
        }
        if (phiRad == 1.5707963267948966) {
            return new PointLL(this.lambdaC_, -90.0);
        }
        double cosPhiOverQ = Math.cos(phiRad * 0.5);
        double lambdaRad = x * this.invRS_ * 0.886226925452758 / Math.cos(phiRad) / (cosPhiOverQ * cosPhiOverQ);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        FoucautStereographic foucautStereographic = this;
        synchronized (foucautStereographic) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.invRS_ * 0.5641895835477563)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double xFactor;
                if (phiRad < 1.5707963267948966) {
                    double cosPhiOverQ = Math.cos(phiRad * 0.5);
                    xFactor = this.invRS_ * 0.886226925452758 / Math.cos(phiRad) / (cosPhiOverQ * cosPhiOverQ);
                } else {
                    xFactor = 0.0;
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

