/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoucautSinusoidal
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Foucaut Sinusoidal";
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private final ProjDoubleParameter ceaParam_;
    private final ProjBooleanParameter rescaleParam_;
    private double ceaWgt_ = 0.5;
    private double sinWgt_ = 1.0 - this.ceaWgt_;
    private boolean yRescaled_;
    private double csubx_ = 1.0;
    private double csuby_ = 1.0;
    private double csubxRS_ = 1.0;
    private double csubyRS_ = 1.0;

    public FoucautSinusoidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public FoucautSinusoidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.ceaParam_ = new ProjDoubleParameter("Weighting of CEA projection", "CEA Wgt", "(0\u2264\u03b1\u22641)", 0.5, 0.0, 1.0, true, true);
        this.rescaleParam_ = new ProjBooleanParameter("Rescale to 2:1 axis ratio", "Rescale", true);
        this.addParameter(this.ceaParam_);
        this.addParameter(this.rescaleParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setCEAWeight(this.ceaParam_.getValue());
            this.setRescale(this.rescaleParam_.isSelected());
        } else if (p == this.ceaParam_) {
            this.setCEAWeight(this.ceaParam_.getValue());
        } else if (p == this.rescaleParam_) {
            this.setRescale(this.rescaleParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setCEAWeight(double ceaWgt) {
        this.ceaWgt_ = ceaWgt;
        this.sinWgt_ = 1.0 - this.ceaWgt_;
        this.autoscale();
    }

    private void setRescale(boolean rescale) {
        this.yRescaled_ = rescale;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double yfactor = 1.0;
        yfactor = this.ceaWgt_ == 1.0 ? 1.0 : (this.ceaWgt_ == 0.0 ? 1.5707963267948966 : this.sinWgt_ * 1.5707963267948966 + this.ceaWgt_);
        if (this.yRescaled_) {
            this.csubx_ = 1.0;
            this.csuby_ = 1.5707963267948966 / yfactor;
            this.setMaxXYOverRS(Math.PI, 1.5707963267948966);
        } else {
            this.csubx_ = 1.0;
            this.csuby_ = 1.0;
            this.setMaxXYOverRS(Math.PI, yfactor);
        }
    }

    @Override
    protected final void finishScaling() {
        this.csubxRS_ = this.csubx_ * this.rS_;
        this.csubyRS_ = this.csuby_ * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double cosPhi = Math.cos(phiRad);
        double lambdaRad = this.lonToLambdaRad(lon);
        if (this.ceaWgt_ == 1.0) {
            x = lambdaRad;
            y = sinPhi;
        } else if (this.ceaWgt_ == 0.0) {
            x = cosPhi * lambdaRad;
            y = phiRad;
        } else {
            x = lambdaRad * cosPhi / (this.sinWgt_ + this.ceaWgt_ * cosPhi);
            y = this.sinWgt_ * phiRad + this.ceaWgt_ * sinPhi;
        }
        x *= this.csubxRS_;
        y *= this.csubyRS_;
        x = (double)this.outCenterX_ + x;
        y = (double)this.outCenterY_ - y;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverCxRS = x / this.csubxRS_;
        double yOverCyRS = y / this.csubyRS_;
        if (this.ceaWgt_ == 1.0) {
            phiRad = Math.asin(yOverCyRS);
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            lambdaRad = xOverCxRS;
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
        } else if (this.ceaWgt_ == 0.0) {
            phiRad = yOverCyRS;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            double cosPhi = Math.cos(phiRad);
            lambdaRad = cosPhi == 0.0 ? 0.0 : xOverCxRS / cosPhi;
        } else {
            double cosPhi;
            double sinPhi;
            phiRad = 1.5707963267948966 * yOverCyRS / (double)this.dyMax_;
            for (int iter = 0; iter < 33; ++iter) {
                sinPhi = Math.sin(phiRad);
                cosPhi = Math.cos(phiRad);
                double func = this.sinWgt_ * phiRad + this.ceaWgt_ * sinPhi - yOverCyRS;
                double dfunc = this.sinWgt_ + this.ceaWgt_ * cosPhi;
                double dphiRad = -func / dfunc;
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            sinPhi = Math.sin(phiRad);
            cosPhi = Math.cos(phiRad);
            lambdaRad = xOverCxRS * (this.sinWgt_ + this.ceaWgt_ * cosPhi) / cosPhi;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        FoucautSinusoidal foucautSinusoidal = this;
        synchronized (foucautSinusoidal) {
            double phiRad = 0.005;
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double cosPhi;
                double sinPhi;
                double y = (double)iy + 0.5;
                double yOverCyRS = y / this.csubyRS_;
                if (this.ceaWgt_ == 1.0) {
                    phiRad = Math.asin(yOverCyRS);
                } else if (this.ceaWgt_ == 0.0) {
                    phiRad = yOverCyRS;
                } else {
                    for (int iter = 0; iter < 33; ++iter) {
                        sinPhi = Math.sin(phiRad);
                        cosPhi = Math.cos(phiRad);
                        double func = this.sinWgt_ * phiRad + this.ceaWgt_ * sinPhi - yOverCyRS;
                        double dfunc = this.sinWgt_ + this.ceaWgt_ * cosPhi;
                        double dphiRad = -func / dfunc;
                        phiRad += dphiRad;
                        if (Math.abs(dphiRad) < 1.0E-5) break;
                    }
                }
                if (phiRad > 1.5707963267948966) break;
                sinPhi = Math.sin(phiRad);
                cosPhi = Math.cos(phiRad);
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverCxRS = x / this.csubxRS_;
                    double lambdaRad = this.ceaWgt_ == 1.0 ? xOverCxRS : (this.ceaWgt_ == 0.0 ? (cosPhi == 0.0 ? 0.0 : xOverCxRS / cosPhi) : xOverCxRS * (this.sinWgt_ + this.ceaWgt_ * cosPhi) / cosPhi);
                    if (lambdaRad > Math.PI) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (this.ceaWgt_ == 1.0) {
            Point2D.Double dotN = this.transformLL2XY(lon, 90.0);
            Point2D.Double dotS = this.transformLL2XY(lon, -90.0);
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            super.drawMeridian(g2d, lon, label);
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.ceaWgt_ == 1.0) {
            ProjectionUtils.drawRect(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
        } else {
            super.drawBorderLines(g2d);
        }
    }
}

