/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class EqualEarth
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Equal Earth";
    public static final int PROPERTIES = 8200;
    private static final double A1 = 1.340264;
    private static final double A2 = -0.081106;
    private static final double A3 = 8.93E-4;
    private static final double A4 = 0.003796;
    private static final double THREE_A2 = -0.24331799999999998;
    private static final double SEVEN_A3 = 0.0062510000000000005;
    private static final double NINE_A4 = 0.034164;
    private static final double SQRT3_OVER_2 = 0.5 * Math.sqrt(3.0);
    private static final double TWO_OVER_SQRT3 = 1.0 / SQRT3_OVER_2;
    private static final double MAX_X_OVER_RS = 2.7066299836960748;
    private static final double MAX_Y_OVER_RS = 1.3173627591574133;

    public EqualEarth(int width, int height) {
        this(width, height, 0, 0);
    }

    public EqualEarth(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8200, width, height, xmargin, ymargin, 2.7066299836960748, 1.3173627591574133);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double thetaRad = Math.asin(SQRT3_OVER_2 * Math.sin(phiRad));
        double thetaRad2 = thetaRad * thetaRad;
        double thetaRad6 = thetaRad2 * thetaRad2 * thetaRad2;
        double lambdaRad = this.lonToLambdaRad(lon);
        double x = lambdaRad * Math.cos(thetaRad) / (SQRT3_OVER_2 * (1.340264 + -0.24331799999999998 * thetaRad2 + thetaRad6 * (0.0062510000000000005 + 0.034164 * thetaRad2)));
        double y = thetaRad * (1.340264 + -0.081106 * thetaRad2 + thetaRad6 * (8.93E-4 + 0.003796 * thetaRad2));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) < 1.0E-5) {
            double lambdaRad = SQRT3_OVER_2 * x * this.invRS_;
            double phiRad = 0.0;
            double phi = Math.toDegrees(0.0);
            double lambda = Math.toDegrees(lambdaRad);
            return new PointLL(this.lambdaC_ + lambda, phi);
        }
        double thetaRad = this.iterateThetaRad(y);
        double thetaRad2 = thetaRad * thetaRad;
        double thetaRad6 = thetaRad2 * thetaRad2 * thetaRad2;
        double phiRad = Math.asin(TWO_OVER_SQRT3 * Math.sin(thetaRad));
        double lambdaRad = Math.abs(x) < 1.0E-5 ? 0.0 : x * this.invRS_ * (SQRT3_OVER_2 * (1.340264 + -0.24331799999999998 * thetaRad2 + thetaRad6 * (0.0062510000000000005 + 0.034164 * thetaRad2))) / Math.cos(thetaRad);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        EqualEarth equalEarth = this;
        synchronized (equalEarth) {
            double y;
            double thetaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(TWO_OVER_SQRT3 * Math.sin(thetaRad = this.iterateThetaRad(y = (double)iy + 0.5)))) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double thetaRad2 = thetaRad * thetaRad;
                double thetaRad6 = thetaRad2 * thetaRad2 * thetaRad2;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * (SQRT3_OVER_2 * (1.340264 + -0.24331799999999998 * thetaRad2 + thetaRad6 * (0.0062510000000000005 + 0.034164 * thetaRad2))) / Math.cos(thetaRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private double iterateThetaRad(double y) {
        double yOverRS = y * this.invRS_;
        double thetaRad = 1.5707963267948966 * yOverRS / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            double thetaRad2 = thetaRad * thetaRad;
            double thetaRad6 = thetaRad2 * thetaRad2 * thetaRad2;
            double func = thetaRad * (1.340264 + -0.081106 * thetaRad2 + thetaRad6 * (8.93E-4 + 0.003796 * thetaRad2)) - yOverRS;
            double dfunc = 1.340264 + -0.24331799999999998 * thetaRad2 + thetaRad6 * (0.0062510000000000005 + 0.034164 * thetaRad2);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        return thetaRad;
    }
}

