/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Eckert6
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Eckert VI";
    private static final double CONST_A = 1.0 / Math.sqrt(5.141592653589793);
    private static final double INV_A = 1.0 / CONST_A;
    private static final double ONE_PLUS_PI_OVER_2 = 2.5707963267948966;
    private static final double MAX_X_OVER_RS = Math.PI * 2 * CONST_A;
    private static final double MAX_Y_OVER_RS = Math.PI * CONST_A;

    public Eckert6(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert6(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double phiFactor = 2.5707963267948966 * Math.sin(phiRad);
        double thetaRad = phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double func = thetaRad + sinTheta - phiFactor;
            double dfunc = 1.0 + cosTheta;
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double x = CONST_A * lambdaRad * (1.0 + Math.cos(thetaRad));
        double y = 2.0 * CONST_A * thetaRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double thetaRad = 0.5 * y * this.invRS_ * INV_A;
        double phiRad = Math.asin((thetaRad + Math.sin(thetaRad)) / 2.5707963267948966);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_ / (CONST_A * (1.0 + Math.cos(thetaRad)));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Eckert6 eckert6 = this;
        synchronized (eckert6) {
            double sinTheta;
            double y;
            double thetaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(((thetaRad = 0.5 * (y = (double)iy + 0.5) * this.invRS_ * INV_A) + (sinTheta = Math.sin(thetaRad))) / 2.5707963267948966)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ / (CONST_A * (1.0 + Math.cos(thetaRad)));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

